#
#	Written by Nick Wang
#
#	Modified by Saul
#
#   - fixed bug noticed by Jason Brechin.  S.Y. Sept. 22, 2005
#
import sys,os
from Platform import *
from Base     import *

class FreeDiskOSError(Exception):
    def __init__(self):
        pass

    def __str__(self):
        return 'Cannot handle the operating system type.'
	
def enoughFreeDisk(minimumDisk,path=pac_anchor):
	r = Reason()
	if localmegs(path)<minimumDisk:
		r = Reason("Out of disk space at ["+path+"].")
	return r

def localmegs(path0):
    path = fullpath(path0)
    p = Platform()
    if sys.platform == 'win32':
        import win32file
        sectorsPerCluster, bytesPerSector, numFreeClusters, totalNumClusters = win32file.GetDiskFreeSpace(path)
        sectorsPerCluster = long(sectorsPerCluster)
        bytesPerSector    = long(bytesPerSector)
        numFreeClusters   = long(numFreeClusters)
        totalNumClusters  = long(totalNumClusters)

        return (numFreeClusters * sectorsPerCluster * bytesPerSector) / (1024*1024)

#    elif sys.platform == 'cygwin':
    elif p.satisfies(PlatformGE('Darwin')):
    	return 999999
    elif p.satisfies(PlatformGE('cygwin')):
        import string
        lines = os.popen('df -m '+path).readlines()
	try:
		val = int(string.split(lines[-1])[3])
	except IndexError:
		abort('Directory ['+path+'] does not exist.')
        return val
        
#    elif sys.platform in ['linux2', 'sunos5']:
    elif p.satisfies(PlatformGE('linux')) or p.satisfies(PlatformGE('sun')):
	if not hasattr(os,'statvfs'): abort("Platform ["+sys.platform+"] does not have STAT available.  Can't use freeDisk.")
        import statvfs
        nfree_blocks = os.statvfs(path)[statvfs.F_BAVAIL]
        blocksize    = os.statvfs(path)[statvfs.F_BSIZE]
        return ((nfree_blocks/1000)*blocksize)/1000
#    elif p.satisfies(Platform('unix')):
    else:
	if not hasattr(os,'statvfs'): abort("Platform ["+sys.platform+"] does not have STAT available.  Can't use freeDisk.")
        import statvfs
        nfree_blocks = os.statvfs(path)[statvfs.F_BAVAIL]
        blocksize    = os.statvfs(path)[statvfs.F_BSIZE]
        return ((nfree_blocks/1000)*blocksize)/1000
#    else:
#    	abort('Unknown platform ['+sys.platform+'].')
#        raise FreeDiskOSError


