#
#	Copyright, Saul Youssef, August 2003
#
from Access     import *
from Execution  import *
from FileGetter import *
import urlAccess2

url_directory_cache = {}

_use_wget = commands.getstatusoutput('which wget')[0]==0
if not _use_wget and not allow('urllib2'): print "Can't find wget.  Using python urllilb2 as a backup..."
		
class URLAccess(Access):
	type = 'url'
	
	def __init__(self,url): 
		self.url = url
		self.location = url
#-- Set
	def __repr__(self): return self.url
	def equal(self,x): return self.url==x.url
	
	def names(self): return self.namesPath()
			
	def namesPath(self,path=''):
		reason = Reason()
		url2 = os.path.join(self.url,path)
		if url_directory_cache.has_key(url2):
			files = url_directory_cache[url2]
		else:
			reason,files = urlAccess2.urlFiles(url2)
			if reason.ok(): 
				url_directory_cache[url2] = files[:]
		return reason,files
			
	def access(self):
		r,files = self.namesPath()
		return r.ok()
	def getFile(self,name2,target=''):
		reason = Reason()
		
		self.url,name = os.path.split(os.path.join(self.url,name2))
		if target=='': target2 = name
		else:          target2 = target
	
		g = InternetFileGetter(self.url,name)
		
		tmpdir = os.path.join(pac_anchor,pacmanDir,'tmp')
		removeFile(os.path.join(tmpdir,name))

#		if (switch('wget') or allow('wget')) and not allow('urllib2'):
		if not allow('urllib2') and _use_wget:
			tries   = httpGetRetries    ()
			pause   = httpGetPause      ()
			timeout = downloadTimeoutGet()
			ver   = verbo('http')
			logfile = os.path.join(pac_anchor,pacmanDir,'logs','wget.log')
			
			verbo.log('http','About to execute [wget --tries='+`tries`+' --waitretry='+`pause`+' --timeout='+`timeout`+' '+os.path.join(self.url,name)+']...')
			if ver: status = os.system('cd '+tmpdir+'; wget --tries='+`tries`+' --waitretry='+`pause`+' --timeout='+`timeout`+' '+os.path.join(self.url,name))
			else:   status = os.system('cd '+tmpdir+'; wget --append-output='+logfile+' --tries='+`tries`+' --waitretry='+`pause`+' --timeout='+`timeout`+' '+os.path.join(self.url,name))
			
			if not status==0: reason = Reason('Failure downloading ['+os.path.join(self.url,name)+'].')
			if reason.ok() and (tail(name,'.tgz') or tail(name,'.gz') or tail(name,'Z')) and not front(name,'CMT'):
#				status = commands.getstatus('zcat '+os.path.join(tmpdir,name))
				status = os.system('zcat '+os.path.join(tmpdir,name)+' > /dev/null 2> /dev/null')
				if not status==0: reason = Reason('Downloaded file ['+name+'] is not in gzip format.')
		else:
			reason = g.get(tmpdir)
		if reason.ok(): 
			try:
				execute('mv '+os.path.join(tmpdir,name)+' '+target2)
			except (IOError,OSError):
				reason = Reason("Failure writing ["+name+"] to ["+target2+"].")					
		return reason

class URLAccessSource(URLAccess):
	cache_cache = {}
	
	def getFile(self,name2,target=''):
		if target=='': target2 = name2
		else:          target2 = target
		
		url,name = os.path.split(os.path.join(self.url,name2))		
		if os.path.isdir(target2): target2 = os.path.join(target2,name)

		reason = Reason()
		if self.cache_cache.has_key((name,url,)):
			lines = self.cache_cache[(name,url,)]
			try: 
				f = open(target2,'w')
				for line in lines: f.write(line)
				f.close()
			except (OSError,IOError):
				reason = Reason("Can't put ["+name+"] in ["+target2+"].")
		else:
			g = InternetFileGetter(url,name)
			tmpdir = os.path.join(pac_anchor,pacmanDir,'tmp')
			removeFile(os.path.join(tmpdir,name))
			
			reason = g.get(tmpdir)
			if reason.ok(): 
				try:
					execute('mv '+os.path.join(tmpdir,name)+' '+target2)
				except (IOError,OSError):
					reason = Reason("Can't put ["+name+"] in ["+target2+"].")
					
			if reason.ok() and tail(name,'.pacman'):
				try:
					f = open(target2,'r')
					lines = f.readlines()
					f.close()
					self.cache_cache[(name,url,)] = lines
				except (IOError,OSError):
					reason = Reason("Can't read ["+target2+"].")
		return reason
	
