#
#	Copyright Saul Youssef, November 2004
#
from Base             import *
from Environment      import *
from StringAttr       import *
import PlatformBase,FinitePreOrder

mtrans = {  'linux-redhat-6.0':'RedHat-6.1',
            'linux-redhat-6.2':'RedHat-6.2',
	    'linux-redhat-6.3':'RedHat-6.3',
	    'linux-redhat-7.0':'RedHat-7.0',
            'linux-redhat-7.1':'RedHat-7.1',
	    'linux-redhat-7.2':'RedHat-7.2',
	    'linux-redhat-7.3':'RedHat-7.3',
	    'linux-redhat-9'  :'RedHat-9',
	    'linux-redhat-8'  :'RedHat-8',
	    'linux-fedora-1'  :'Fedora-1',
	    'linux-fedora-2'  :'Fedora-2',
	    'linux-fedora-3'  :'Fedora-3',
	    'linux-fedora-4'  :'Fedora-4',
	    'linux-rhel-1'    :'RHEL-1',
	    'linux-rhel-2'    :'RHEL-2',
	    'linux-rhel-3'    :'RHEL-3',
	    'linux-rhel-4'    :'RHEL-4',
	    'linux-rhel-5'    :'RHEL-5',
	    'linux-suse-1'    :'SuSE-1',
	    'linux-suse-2'    :'SuSE-2',
	    'linux-suse-3'    :'SuSE-3',
	    'linux-suse-4'    :'SuSE-4',
	    'linux-suse-5'    :'SuSE-5',
	    'linux-suse-6'    :'SuSE-6',
	    'linux-suse-7'    :'SuSE-7',
	    'linux-suse-8'    :'SuSE-8',
	    'linux-suse-9'    :'SuSE-9',
	    'linux-suse-9.1'  :'SuSE-9.1',
	    'linux-suse-9.2'  :'SuSE-9.2',
	    'linux-suse-9.3'  :'SuSE-9.3',
	    'linux-debian-1'  :'Debian-1',
	    'linux-debian-2'  :'Debian-2',
	    'linux-debian-3'  :'Debian-3',
	    'linux-debian-4'  :'Debian-4',
	    'linux-debian-5'  :'Debian-5',
	    'linux-debian-6'  :'Debian-6',
	    'linux-debian-7'  :'Debian-7',
	    'darwin'          :'Darwin',
	    'linux-debian-3.0':'Debian-3.0',
	    'linux-debian-3.1':'Debian-3.1',
	    'linux-debian-3.2':'Debian-3.2',
	    'linux-debian-3.3':'Debian-3.3',
	    'linux-debian-3.4':'Debian-3.4',
	    'linux-sl-3.0'    :'SL-3.0',
	    'linux-sl-3.1'    :'SL-3.1',
	    'linux-sl-3.2'    :'SL-3.2',
	    'linux-sl-3.3'    :'SL-3.3',
	    'linux-sl-3.4'    :'SL-3.4',
	    'linux-sl-3.5'    :'SL-3.5',
	    'linux-sl-3.6'    :'SL-3.6',
	    'linux-sl-3.7'    :'SL-3.7',
	    'linux-sl-fermi-3.0' :'Fermi-SL-3.0',
	    'linux-sl-fermi-3.1' :'Fermi-SL-3.1',
	    'linux-sl-fermi-3.2' :'Fermi-SL-3.2',
	    'linux-sl-fermi-3.3' :'Fermi-SL-3.3',
	    'linux-sl-fermi-3.4' :'Fermi-SL-3.4',
	    'linux-sl-fermi-3.5' :'Fermi-SL-3.5',
	    'linux-sl-fermi-3.6' :'Fermi-SL-3.6',
	    'linux-sl-fermi-3.7' :'Fermi-SL-3.7',
	    'linux-sl-cern-3.0' :'CERN-SL-3.0',
	    'linux-sl-cern-3.1' :'CERN-SL-3.1',
	    'linux-sl-cern-3.2' :'CERN-SL-3.2',
	    'linux-sl-cern-3.3' :'CERN-SL-3.3',
	    'linux-sl-cern-3.4' :'CERN-SL-3.4',
	    'linux-sl-cern-3.5' :'CERN-SL-3.5',
	    'linux-sl-cern-3.6' :'CERN-SL-3.6',
	    'linux-sl-cern-3.7' :'CERN-SL-3.7',
	    'linux-sl-ific-3.0' :'IFIC-SL-3.0',
	    'linux-sl-ific-3.1' :'IFIC-SL-3.1',
	    'linux-sl-ific-3.2' :'IFIC-SL-3.2',
	    'linux-sl-ific-3.3' :'IFIC-SL-3.3',
	    'linux-sl-ific-3.4' :'IFIC-SL-3.4',
	    'linux-sl-ific-3.5' :'IFIC-SL-3.5',
	    'linux-sl-ific-3.6' :'IFIC-SL-3.6',
	    'linux-sl-ific-3.7' :'IFIC-SL-3.7',
	    'linux-rocks-3.0'    :'Rocks-3.0',
	    'linux-rocks-3.1'    :'Rocks-3.1',
	    'linux-rocks-3.2'    :'Rocks-3.2',
	    'linux-rocks-3.3'    :'Rocks-3.3',
	    'linux-rocks-3.4'    :'Rocks-3.4',
	    'linux-rocks-3.5'    :'Rocks-3.5',
	    'linux-rocks-3.5'    :'Rocks-3.6',
	    'linux-sl-4.0'    :'SL-4.0',
	    'linux-sl-4.1'    :'SL-4.1',
	    'linux-sl-4.2'    :'SL-4.2',
	    'linux-sl-4.3'    :'SL-4.3',
	    'linux-sl-4.4'    :'SL-4.4',
	    'linux-sl-4.5'    :'SL-4.5',
	    'linux-sl-4.6'    :'SL-4.6',
	    'linux-sl-4.7'    :'SL-4.7',
	    'linux-sl-fermi-4.0' :'Fermi-SL-4.0',
	    'linux-sl-fermi-4.1' :'Fermi-SL-4.1',
	    'linux-sl-fermi-4.2' :'Fermi-SL-4.2',
	    'linux-sl-fermi-4.3' :'Fermi-SL-4.3',
	    'linux-sl-fermi-4.4' :'Fermi-SL-4.4',
	    'linux-sl-fermi-4.5' :'Fermi-SL-4.5',
	    'linux-sl-fermi-4.6' :'Fermi-SL-4.6',
	    'linux-sl-fermi-4.7' :'Fermi-SL-4.7',
	    'linux-sl-cern-4.0' :'CERN-SL-4.0',
	    'linux-sl-cern-4.1' :'CERN-SL-4.1',
	    'linux-sl-cern-4.2' :'CERN-SL-4.2',
	    'linux-sl-cern-4.3' :'CERN-SL-4.3',
	    'linux-sl-cern-4.4' :'CERN-SL-4.4',
	    'linux-sl-cern-4.5' :'CERN-SL-4.5',
	    'linux-sl-cern-4.6' :'CERN-SL-4.6',
	    'linux-sl-cern-4.7' :'CERN-SL-4.7',
	    'linux-sl-ific-4.0' :'IFIC-SL-4.0',
	    'linux-sl-ific-4.1' :'IFIC-SL-4.1',
	    'linux-sl-ific-4.2' :'IFIC-SL-4.2',
	    'linux-sl-ific-4.3' :'IFIC-SL-4.3',
	    'linux-sl-ific-4.4' :'IFIC-SL-4.4',
	    'linux-sl-ific-4.5' :'IFIC-SL-4.5',
	    'linux-sl-ific-4.6' :'IFIC-SL-4.6',
	    'linux-sl-ific-4.7' :'IFIC-SL-4.7',
	    'linux-rocks-4.0'    :'Rocks-4.0',
	    'linux-rocks-4.1'    :'Rocks-4.1',
	    'linux-rocks-4.2'    :'Rocks-4.2',
	    'linux-rocks-4.3'    :'Rocks-4.3',
	    'linux-rocks-4.4'    :'Rocks-4.4',
	    'linux-rocks-4.5'    :'Rocks-4.5',
	    'linux-rocks-4.5'    :'Rocks-4.6',
	    'linux-sl-5.0'    :'SL-5.0',
	    'linux-sl-5.1'    :'SL-5.1',
	    'linux-sl-5.2'    :'SL-5.2',
	    'linux-sl-5.3'    :'SL-5.3',
	    'linux-sl-5.4'    :'SL-5.4',
	    'linux-sl-5.5'    :'SL-5.5',
	    'linux-sl-5.6'    :'SL-5.6',
	    'linux-sl-5.7'    :'SL-5.7',
	    'linux-sl-fermi-5.0' :'Fermi-SL-5.0',
	    'linux-sl-fermi-5.1' :'Fermi-SL-5.1',
	    'linux-sl-fermi-5.2' :'Fermi-SL-5.2',
	    'linux-sl-fermi-5.3' :'Fermi-SL-5.3',
	    'linux-sl-fermi-5.4' :'Fermi-SL-5.4',
	    'linux-sl-fermi-5.5' :'Fermi-SL-5.5',
	    'linux-sl-fermi-5.6' :'Fermi-SL-5.6',
	    'linux-sl-fermi-5.7' :'Fermi-SL-5.7',
	    'linux-BU-4.5s'      :'BU-Linux 4.5s',
	    'linux-sl-cern-5.0' :'CERN-SL-5.0',
	    'linux-sl-cern-5.1' :'CERN-SL-5.1',
	    'linux-sl-cern-5.2' :'CERN-SL-5.2',
	    'linux-sl-cern-5.3' :'CERN-SL-5.3',
	    'linux-sl-cern-5.4' :'CERN-SL-5.4',
	    'linux-sl-cern-5.5' :'CERN-SL-5.5',
	    'linux-sl-cern-5.6' :'CERN-SL-5.6',
	    'linux-sl-cern-5.7' :'CERN-SL-5.7',
	    'linux-sl-ific-5.0' :'IFIC-SL-5.0',
	    'linux-sl-ific-5.1' :'IFIC-SL-5.1',
	    'linux-sl-ific-5.2' :'IFIC-SL-5.2',
	    'linux-sl-ific-5.3' :'IFIC-SL-5.3',
	    'linux-sl-ific-5.4' :'IFIC-SL-5.4',
	    'linux-sl-ific-5.5' :'IFIC-SL-5.5',
	    'linux-sl-ific-5.6' :'IFIC-SL-5.6',
	    'linux-sl-ific-5.7' :'IFIC-SL-5.7',
	    'linux-centos-4.0' :'CentOS-4.0',
	    'linux-centos-4.1' :'CentOS-4.1',
	    'linux-centos-4.2' :'CentOS-4.2',
	    'linux-centos-4.3' :'CentOS-4.3',
	    'linux-centos-4.4' :'CentOS-4.4',
	    'linux-centos-4.5' :'CentOS-4.5',
	    'linux-centos-4.6' :'CentOS-4.6',
	    'linux-centos-4.7' :'CentOS-4.7',
	    'linux-rocks-5.0'    :'Rocks-5.0',
	    'linux-rocks-5.1'    :'Rocks-5.1',
	    'linux-rocks-5.2'    :'Rocks-5.2',
	    'linux-rocks-5.3'    :'Rocks-5.3',
	    'linux-rocks-5.4'    :'Rocks-5.4',
	    'linux-rocks-5.5'    :'Rocks-5.5',
	    'linux-rocks-5.5'    :'Rocks-5.6' }

machines = []

#
#-- make all the translated names equivalent to their translation
#
for key,val in mtrans.items():
	machines.append((key,val,))
	machines.append((val,key,))

#
#-- Unix
#
machines.append(('Unix',          '*',))
machines.append(('Sun',        'Unix',))
machines.append(('FreeBSD',    'Unix',))
machines.append(('Aix',        'Unix',))
machines.append(('OSF1',       'Unix',))
machines.append(('Cygwin',     'Unix',))
machines.append(('Darwin',     'Unix',))
machines.append(('Irix',       'Unix',))
machines.append(('unix',       'Unix',))
machines.append(('Unix',       'unix',))

#
#-- Linux
#
machines.append(('Linux',     'linux',))
machines.append(('linux',     'Linux',))
machines.append(('Linux',      'Unix',))
machines.append(('RedHat',    'Linux',))
machines.append(('linux2',    'Linux',))
machines.append(('SuSE',      'Linux',))
machines.append(('Fedora',    'Linux',))
machines.append(('RHEL',      'Linux',))
machines.append(('Debian',    'Linux',))
machines.append(('linux',     'Linux',))
machines.append(('Linux',     'linux',))
machines.append(('Tao',       'Linux',))
machines.append(('SL',        'Linux',))
machines.append(('Rocks',     'Linux',))
machines.append(('BU-Linux',  'Linux',))
machines.append(('CentOS',    'Linux',))

#
#-- Scientific Linux Family
#
machines.append(('Fermi-SL',           'SL',))
machines.append(('SLC',                'SL',))
machines.append(('CERN-SL',           'SLC',))
machines.append(('SLC',           'CERN-SL',))
machines.append(('IFIC-SL',           'SLI',))
machines.append(('SLI',           'IFIC-SL',))
machines.append(('SLI',                'SL',))

#
#-- Debian
#
machines.append(('Debian','debian',         ))
machines.append(('debian','Debian',         ))
machines.append(('Debian-3.4','Debian-3.3', ))
machines.append(('Debian-3.3','Debian-3.2', ))
machines.append(('Debian-3.2','Debian-3.1', ))
machines.append(('Debian-3.1','Debian-3.0', ))
machines.append(('Debian-3.0','Debian-3',   ))
machines.append(('Debian-4','Debian-3',     ))
machines.append(('Debian-3','Debian-2',     ))
machines.append(('Debian-2','Debian-1',     ))
machines.append(('Debian-1','Debian',       ))

#
#-- Red Hat Enterprise Linux
#
machines.append((   'RHEL-5',  'RHEL-4',    ))
machines.append((   'RHEL-4',  'RHEL-3',    ))
machines.append((   'RHEL-3',  'RHEL-2',    ))
machines.append((   'RHEL-2',  'RHEL-1',    ))
machines.append((   'RHEL-1',  'RHEL',      ))

#
#-- SuSE linux
#
machines.append((   'SuSE',    'suse',    ))
machines.append((   'suse',    'SuSE',    ))
machines.append((   'SuSE-9.3','SuSE-9.2',))
machines.append((   'SuSE-9.2','SuSE-9.1',))
machines.append((   'SuSE-9.1','SuSE-9',  ))
machines.append((   'SuSE-9',  'SuSE-8',  ))
machines.append((   'SuSE-8',  'SuSE-7',  ))
machines.append((   'SuSE-7',  'SuSE-6',  ))
machines.append((   'SuSE-6',  'SuSE-5',  ))
machines.append((   'SuSE-5',  'SuSE-4',  ))
machines.append((   'SuSE-4',  'SuSE-3',  ))
machines.append((   'SuSE-3',  'SuSE-2',  ))
machines.append((   'SuSE-2',  'SuSE-1',  ))
machines.append((   'SuSE-1',  'SuSE',    ))

#
#-- CentOS
#
machines.append(('CentOS-4.7','CentOS-4.6',))
machines.append(('CentOS-4.6','CentOS-4.5',))
machines.append(('CentOS-4.5','CentOS-4.4',))
machines.append(('CentOS-4.4','CentOS-4.3',))
machines.append(('CentOS-4.3','CentOS-4.2',))
machines.append(('CentOS-4.2','CentOS-4.1',))
machines.append(('CentOS-4.1','CentOS-4.0',))
machines.append(('CentOS-4.0','CentOS-4'  ,))
machines.append(('CentOS-4',  'RHEL-4'    ,))
machines.append(('CentOS-4',  'CentOS'    ,))

#
#-- Sun
#
machines.append((     'sun',      'Sun',))
machines.append((     'Sun',      'sun',))
machines.append((  'sunos5',   'sunos4',))
machines.append((  'sunos4',   'sunos3',))
machines.append((  'sunos3',   'sunos2',))
machines.append((  'sunos2',    'sunos',))
machines.append((   'sunos',      'sun',))


#
#-- Freebsd
#
machines.append((  'FreeBSD',    'freebsd',))
machines.append((  'freebsd',    'FreeBSD',))
machines.append((  'freebsd6',  'freebsd5',))
machines.append((  'freebsd5',  'freebsd4',))
machines.append((  'freebsd4',  'freebsd3',))
machines.append((  'freebsd3',  'freebsd2',))
machines.append((  'freebsd2',  'freebsd1',))
machines.append((  'freebsd1',   'freebsd',))

#
#-- Irix
#
machines.append((    'irix',   'Irix',))
machines.append((    'Irix',   'irix',))
machines.append((   'irix7',  'irix6',))
machines.append((   'irix6',  'irix5',))
machines.append((   'irix5',  'irix4',))
machines.append((   'irix4',   'irix',))

#
#-- Fedora
#
machines.append((  'fedora',  'Fedora',    ))
machines.append((  'Fedora',  'fedora',    ))
machines.append(( 'Fedora-4', 'Fedora-3',  ))
machines.append(( 'Fedora-3', 'Fedora-2',  ))
machines.append(( 'Fedora-2', 'Fedora-1',  ))
machines.append(( 'Fedora-1', 'Fedora',    ))

#
#-- aix
#
machines.append((   'aix-5.7', 'aix-5.6',))
machines.append((   'aix-5.6', 'aix-5.5',))
machines.append((   'aix-5.5', 'aix-5.4',))
machines.append((   'aix-5.4', 'aix-5.3',))
machines.append((   'aix-5.3', 'aix-5.2',))
machines.append((   'aix-5.2', 'aix-5.1',))
machines.append((   'aix-5.1', 'aix-5.0',))
machines.append((   'aix-5.0',    'aix5',))
machines.append((      'aix5',    'aix4',))
machines.append((      'aix4',    'aix3',))
machines.append((      'aix3',    'aix2',))
machines.append((      'aix2',    'aix', ))
machines.append((       'aix',     'AIX',))
machines.append((       'AIX',     'aix',))
machines.append((       'aix',     'Aix',))
machines.append((       'Aix',     'aix',))

#
#-- OSF1
#
machines.append((   'OSF1-V7','OSF1-V6',))
machines.append((   'OSF1-V6','OSF1-V5',))
machines.append((   'OSF1-V5','OSF1-V4',))
machines.append((   'OSF1-V4','OSF1-V3',))
machines.append((   'OSF1-V3','OSF1-V2',))
machines.append((   'OSF1-V2','OSF1-V1',))
machines.append((   'OSF1-V1','OSF1'   ,))

#
#-- cygwin
#
machines.append((  'cygwin', 'Cygwin',))
machines.append((  'Cygwin', 'cygwin',))
machines.append((  'cygwin', 'CygWin',))
machines.append((  'CygWin', 'cygwin',))

#
#-- darwin
#
machines.append((  'darwin-10.7', 'darwin-10.6',))
machines.append((  'darwin-10.6', 'darwin-10.5',))
machines.append((  'darwin-10.5', 'darwin-10.4',))
machines.append((  'darwin-10.4', 'darwin-10.3',))
machines.append((  'darwin-10.3', 'darwin-10.2',))
machines.append((  'darwin-10.2', 'darwin-10.1',))
machines.append((  'darwin-10.1', 'darwin-10.0',))
machines.append((  'darwin-10.0', 'darwin',     ))
machines.append((  'darwin',      'Darwin',     ))
machines.append((  'Darwin',      'darwin',     ))

#
#-- MacOS
#
#machines.append((   'MacOS-X 10.4',  'MacOS-X',  ))
#machines.append((   'MacOS-X',       'MacOS',    ))
machines.append((   'MacOS',         'Mac OS',   ))
machines.append((   'Mac OS',        'MacOS',    ))
machines.append((   'MacOS',         'Darwin',   ))
machines.append((  'Darwin',         'MacOS',    ))

#
#-- misc
#
machines.append(('linux-i386',  'Linux',   ))
machines.append(('linux-i686',  'Linux',   ))
machines.append(('Mandrake',    'Linux',   ))
machines.append(('linux2',      'Linux',   ))

#
#-- Red Hat
#
machines.append(('RedHat-9',  'Redhat-9',  ))
machines.append(('Redhat-9',  'RedHat-9',  ))
machines.append(('RedHat-8',  'Redhat-8',  ))
machines.append(('Redhat-8',  'RedHat-8',  ))
machines.append(('RedHat-7',  'Redhat-7',  ))
machines.append(('Redhat-7',  'RedHat-7',  ))
machines.append(('RedHat-6',  'Redhat-6',  ))
machines.append(('Redhat-6',  'RedHat-6',  ))

machines.append(('RedHat-7.0', 'Redhat-7.0'))
machines.append(('Redhat-7.0', 'RedHat-7.0'))
machines.append(('RedHat-7.0', 'redhat-7.0'))
machines.append(('redhat-7.0', 'RedHat-7.0'))

machines.append(('RedHat-7.1', 'Redhat-7.1'))
machines.append(('Redhat-7.1', 'RedHat-7.1'))
machines.append(('RedHat-7.1', 'redhat-7.1'))
machines.append(('redhat-7.1', 'RedHat-7.1'))

machines.append(('RedHat-7.2', 'Redhat-7.2'))
machines.append(('Redhat-7.2', 'RedHat-7.2'))
machines.append(('RedHat-7.2', 'redhat-7.2'))
machines.append(('redhat-7.2', 'RedHat-7.2'))

machines.append(('RedHat-7.3', 'Redhat-7.3'))
machines.append(('Redhat-7.3', 'RedHat-7.3'))
machines.append(('RedHat-7.3', 'redhat-7.3'))
machines.append(('redhat-7.3', 'RedHat-7.3'))

machines.append(('RedHat-6.2', 'Redhat-6.2'))
machines.append(('Redhat-6.2', 'RedHat-6.2'))
machines.append(('RedHat-6.2', 'redhat-6.2'))
machines.append(('redhat-6.2', 'RedHat-6.2'))

machines.append(('RedHat-6.1', 'Redhat-6.1'))
machines.append(('Redhat-6.1', 'RedHat-6.1'))
machines.append(('RedHat-6.1', 'redhat-6.1'))
machines.append(('redhat-6.1', 'RedHat-6.1'))

machines.append(('RedHat-6.0', 'Redhat-6.0'))
machines.append(('Redhat-6.0', 'RedHat-6.0'))
machines.append(('RedHat-6.0', 'redhat-6.0'))
machines.append(('redhat-6.0', 'RedHat-6.0'))

machines.append(('RedHat-7.4', 'Redhat-7.4'))
machines.append(('Redhat-7.4', 'RedHat-7.4'))
machines.append(('RedHat-7.4', 'redhat-7.4'))
machines.append(('redhat-7.4', 'RedHat-7.4'))

machines.append(('RedHat-9',  'RedHat-8',  ))
machines.append(('RedHat-8',  'RedHat-7',  ))
machines.append(('RedHat-7',  'RedHat',    ))

machines.append(('RedHat-7.4','RedHat-7.3',))
machines.append(('RedHat-7.3','RedHat-7.2',))
machines.append(('RedHat-7.2','RedHat-7.1',))
machines.append(('RedHat-7.1','RedHat-7.0',))
machines.append(('RedHat-7.0','RedHat-7',  ))
machines.append(('RedHat-7'  ,'RedHat-6',  ))
machines.append(('RedHat-6.2','RedHat-6.1',))
machines.append(('RedHat-6.1','RedHat-6.0',))
machines.append(('RedHat-6.1','RedHat-6',  ))
machines.append(('RedHat-6',  'RedHat',    ))

machines.append(('redhat',    'RedHat',    ))
machines.append(('RedHat',    'redhat',    ))
machines.append(('RedHat',    'Redhat',    ))
machines.append(('Redhat',    'RedHat',    ))

#
#-- fermi-linux
#
machines.append(( 'linux-fermi-7.4','linux-fermi-7.3',))
machines.append(( 'linux-fermi-7.3','linux-fermi-7.2',))
machines.append(( 'linux-fermi-7.2','linux-fermi-7.1',))
machines.append(( 'linux-fermi-9.0','linux-fermi-9.0',))
machines.append(( 'linux-fermi-7.1','linux-fermi',    ))
machines.append(( 'linux-fermi',    'Linux',          ))

#
#-- Tao Linx
#
machines.append(('linux-tao-1',   'TAO-1',        ))
machines.append(('TAO-1',         'linux-tao-1',  ))
machines.append(('TAO-1',         'Tao-1',        ))
machines.append(('Tao-1',         'TAO-1',        ))
machines.append(('Tao-1',         'Tao',          ))

#
#-- BU Linux
#
machines.append(('BU-Linux 4.5s','BU-Linux',))
machines.append(('BU-Linux 4.5s','RHEL-4',)); machines.append(('RHEL-4','BU-Linux 4.5s',))

#
#-- Rocks
#
machines.append(('Rocks-4.4','Rocks-4.3',  ))
machines.append(('Rocks-4.3','Rocks-4.2',  ))
machines.append(('Rocks-4.2','Rocks-4.1',  ))
machines.append(('Rocks-4.1','Rocks-4.0',  ))
machines.append(('Rocks-4.0','Rocks-4',    ))
machines.append(('Rocks-4'  ,'Rocks',      ))
machines.append(('Rocks-4'  ,'Rocks-3.3',  ))
machines.append(('Rocks-3.3','Rocks-3.2',  ))
machines.append(('Rocks-3.2','Rocks-3.1',  ))
machines.append(('Rocks-3.1','Rocks-3.0',  ))
machines.append(('Rocks-3.0','Rocks-3',    ))
machines.append(('Rocks-3'  ,'Rocks',      ))

machines.append(('Rocks-3',  'RHEL-3'   ))
machines.append(('Rocks-3.0','RHEL-3'   ))
machines.append(('Rocks-3.1','RHEL-3'   ))
machines.append(('Rocks-3.2','RHEL-3'   ))
machines.append(('Rocks-3.3','RHEL-3'   ))

#
#-- Vanilla Scientific Linux 
#
machines.append(('SL-5.4','SL-5.3',  ))
machines.append(('SL-5.3','SL-5.2',  ))
machines.append(('SL-5.2','SL-5.1',  ))
machines.append(('SL-5.1','SL-5.0',  ))
machines.append(('SL-5.0','SL-5',    ))
machines.append(('SL-5'  ,'SL',      ))
machines.append(('SL-5'  ,'SL-4.4',  ))

machines.append(('SL-4.4','SL-4.3',  ))
machines.append(('SL-4.3','SL-4.2',  ))
machines.append(('SL-4.2','SL-4.1',  ))
machines.append(('SL-4.1','SL-4.0',  ))
machines.append(('SL-4.0','SL-4',    ))
machines.append(('SL-4'  ,'SL',      ))
machines.append(('SL-4'  ,'SL-3.3',  ))

machines.append(('SL-3.3','SL-3.2',  ))
machines.append(('SL-3.2','SL-3.1',  ))
machines.append(('SL-3.1','SL-3.0',  ))
machines.append(('SL-3.0','SL-3',    ))
machines.append(('SL-3'  ,'SL',      ))

#
#-- SL versions are supersets of RHEL versions, so...
#
machines.append(('SL',        'RHEL',))
machines.append(('SL-3',    'RHEL-3',))
machines.append(('SL-3.0','RHEL-3.0',))
machines.append(('SL-3.1','RHEL-3.1',))
machines.append(('SL-3.2','RHEL-3.2',))
machines.append(('SL-3.3','RHEL-3.3',))
machines.append(('SL-4',   'RHEL-4', ))
machines.append(('SL-4.0','RHEL-4.0',))
machines.append(('SL-4.1','RHEL-4.1',))
machines.append(('SL-4.2','RHEL-4.2',))
machines.append(('SL-4.3','RHEL-4.3',))
machines.append(('SL-4.4','RHEL-4.4',))
machines.append(('SL-5',   'RHEL-5', ))
machines.append(('SL-5.0','RHEL-5.0',))
machines.append(('SL-5.1','RHEL-5.1',))
machines.append(('SL-5.2','RHEL-5.2',))
machines.append(('SL-5.3','RHEL-5.3',))
machines.append(('SL-5.4','RHEL-5.4',))

#
#-- CERN Scientific Linux 
#
machines.append(('SLC-5.4','SLC-5.3',  ))
machines.append(('SLC-5.3','SLC-5.2',  ))
machines.append(('SLC-5.2','SLC-5.1',  ))
machines.append(('SLC-5.1','SLC-5.0',  ))
machines.append(('SLC-5.0','SLC-5',    ))
machines.append(('SLC-5'  ,'SLC',      ))
machines.append(('SLC-4.4','SLC-4.3',  ))
machines.append(('SLC-4.3','SLC-4.2',  ))
machines.append(('SLC-4.2','SLC-4.1',  ))
machines.append(('SLC-4.1','SLC-4.0',  ))
machines.append(('SLC-4.0','SLC-4',    ))
machines.append(('SLC-4'  ,'SLC',      ))
machines.append(('SLC-4'  ,'SLC-3.3',  ))
machines.append(('SLC-3.3','SLC-3.2',  ))
machines.append(('SLC-3.2','SLC-3.1',  ))
machines.append(('SLC-3.1','SLC-3.0',  ))
machines.append(('SLC-3.0','SLC-3',    ))
machines.append(('SLC-3'  ,'SLC',      ))
machines.append(('SLC-4.4','SL-4.4'    ))
machines.append(('SLC-4.3','SL-4.3'    ))
machines.append(('SLC-4.2','SL-4.2'    ))
machines.append(('SLC-4.1','SL-4.1'    ))
machines.append(('SLC-4.0','SL-4.0'    ))
machines.append(('SLC-4'  ,'SL-4',     ))
machines.append(('SLC-4'  ,'SLC-3.3',  ))
machines.append(('SLC-3.3','SL-3.3',   ))
machines.append(('SLC-3.2','SL-3.2',   ))
machines.append(('SLC-3.1','SL-3.1',   ))
machines.append(('SLC-3.0','SL-3.0',   ))
machines.append(('SLC-3'  ,'SL-3',     ))

machines.append(('SLC-5.4','CERN-SL-5.4',)); machines.append(('CERN-SL-5.4','SLC-5.4',))
machines.append(('SLC-5.3','CERN-SL-5.3',)); machines.append(('CERN-SL-5.3','SLC-5.3',))
machines.append(('SLC-5.2','CERN-SL-5.2',)); machines.append(('CERN-SL-5.2','SLC-5.2',))
machines.append(('SLC-5.1','CERN-SL-5.1',)); machines.append(('CERN-SL-5.1','SLC-5.1',))
machines.append(('SLC-5.0','CERN-SL-5.0',)); machines.append(('CERN-SL-5.0','SLC-5.0',))
machines.append(('SLC-5'  ,'CERN-SL-5'  ,)); machines.append(('CERN-SL-5',  'SLC-5',  ))

machines.append(('SLC-4.4','CERN-SL-4.4',)); machines.append(('CERN-SL-4.4','SLC-4.4',))
machines.append(('SLC-4.3','CERN-SL-4.3',)); machines.append(('CERN-SL-4.3','SLC-4.3',))
machines.append(('SLC-4.2','CERN-SL-4.2',)); machines.append(('CERN-SL-4.2','SLC-4.2',))
machines.append(('SLC-4.1','CERN-SL-4.1',)); machines.append(('CERN-SL-4.1','SLC-4.1',))
machines.append(('SLC-4.0','CERN-SL-4.0',)); machines.append(('CERN-SL-4.0','SLC-4.0',))
machines.append(('SLC-4'  ,'CERN-SL-4'  ,)); machines.append(('CERN-SL-4',  'SLC-4',  ))

machines.append(('SLC-3.4','CERN-SL-3.4',)); machines.append(('CERN-SL-3.4','SLC-3.4',))
machines.append(('SLC-3.3','CERN-SL-3.3',)); machines.append(('CERN-SL-3.3','SLC-3.3',))
machines.append(('SLC-3.2','CERN-SL-3.2',)); machines.append(('CERN-SL-3.2','SLC-3.2',))
machines.append(('SLC-3.1','CERN-SL-3.1',)); machines.append(('CERN-SL-3.1','SLC-3.1',))
machines.append(('SLC-3.0','CERN-SL-3.0',)); machines.append(('CERN-SL-3.0','SLC-3.0',))
machines.append(('SLC-3'  ,'CERN-SL-3'  ,)); machines.append(('CERN-SL-3',  'SLC-3',  ))

machines.append(('slc5.4','CERN-SL-5.4',)); machines.append(('CERN-SL-5.4','slc5.4',  ))
machines.append(('slc5.3','CERN-SL-5.3',)); machines.append(('CERN-SL-5.3','slc5.3',  ))
machines.append(('slc5.2','CERN-SL-5.2',)); machines.append(('CERN-SL-5.2','slc5.2',  ))
machines.append(('slc5.1','CERN-SL-5.1',)); machines.append(('CERN-SL-5.1','slc5.1',  ))
machines.append(('slc5.0','CERN-SL-5.0',)); machines.append(('CERN-SL-5.0','slc5.0',  ))
machines.append(('slc5'  ,'CERN-SL-5'  ,)); machines.append(('CERN-SL-5',  'slc5',    ))

machines.append(('slc4.4','CERN-SL-4.4',)); machines.append(('CERN-SL-4.4','slc4.4',  ))
machines.append(('slc4.3','CERN-SL-4.3',)); machines.append(('CERN-SL-4.3','slc4.3',  ))
machines.append(('slc4.2','CERN-SL-4.2',)); machines.append(('CERN-SL-4.2','slc4.2',  ))
machines.append(('slc4.1','CERN-SL-4.1',)); machines.append(('CERN-SL-4.1','slc4.1',  ))
machines.append(('slc4.0','CERN-SL-4.0',)); machines.append(('CERN-SL-4.0','slc4.0',  ))
machines.append(('slc4'  ,'CERN-SL-4'  ,)); machines.append(('CERN-SL-4',  'slc4',    ))

machines.append(('slc3.4','CERN-SL-3.4',)); machines.append(('CERN-SL-3.4','slc3.4',  ))
machines.append(('slc3.3','CERN-SL-3.3',)); machines.append(('CERN-SL-3.3','slc3.3',  ))
machines.append(('slc3.2','CERN-SL-3.2',)); machines.append(('CERN-SL-3.2','slc3.2',  ))
machines.append(('slc3.1','CERN-SL-3.1',)); machines.append(('CERN-SL-3.1','slc3.1',  ))
machines.append(('slc3.0','CERN-SL-3.0',)); machines.append(('CERN-SL-3.0','slc3.0',  ))
machines.append(('slc3'  ,'CERN-SL-3'  ,)); machines.append(('CERN-SL-3',  'slc3',    ))

#
#-- Fermi Scientific Linux
#
machines.append(('Fermi-SL-5.4','Fermi-SL-5.3',  ))
machines.append(('Fermi-SL-5.3','Fermi-SL-5.2',  ))
machines.append(('Fermi-SL-5.2','Fermi-SL-5.1',  ))
machines.append(('Fermi-SL-5.1','Fermi-SL-5.0',  ))
machines.append(('Fermi-SL-5.0','Fermi-SL-5',    ))
machines.append(('Fermi-SL-5'  ,'Fermi-SL',      ))
machines.append(('Fermi-SL-4.4','Fermi-SL-4.3',  ))
machines.append(('Fermi-SL-4.3','Fermi-SL-4.2',  ))
machines.append(('Fermi-SL-4.2','Fermi-SL-4.1',  ))
machines.append(('Fermi-SL-4.1','Fermi-SL-4.0',  ))
machines.append(('Fermi-SL-4.0','Fermi-SL-4',    ))
machines.append(('Fermi-SL-4'  ,'Fermi-SL',      ))
machines.append(('Fermi-SL-4'  ,'Fermi-SL-3.3',  ))
machines.append(('Fermi-SL-3.3','Fermi-SL-3.2',  ))
machines.append(('Fermi-SL-3.2','Fermi-SL-3.1',  ))
machines.append(('Fermi-SL-3.1','Fermi-SL-3.0',  ))
machines.append(('Fermi-SL-3.0','Fermi-SL-3',    ))
machines.append(('Fermi-SL-3'  ,'Fermi-SL',      ))
machines.append(('Fermi-SL-4.4','SL-4.4',        ))
machines.append(('Fermi-SL-4.3','SL-4.3',        ))
machines.append(('Fermi-SL-4.2','SL-4.2',        ))
machines.append(('Fermi-SL-4.1','SL-4.1',        ))
machines.append(('Fermi-SL-4.0','SL-4.0',        ))
machines.append(('Fermi-SL-4'  ,'SL-4',          ))
machines.append(('Fermi-SL-4'  ,'Fermi-SL-3.3',  ))
machines.append(('Fermi-SL-3.3','SL-3.3',        ))
machines.append(('Fermi-SL-3.2','SL-3.2',        ))
machines.append(('Fermi-SL-3.1','SL-3.1',        ))
machines.append(('Fermi-SL-3.0','SL-3.0',        ))
machines.append(('Fermi-SL-3'  ,'SL-3',          ))
		
supportedPlatforms = ['BU-Linux','RedHat','CentOS','Fedora','Cygwin','RHEL','AIX','SuSE', 'Debian','Tao','SL','OSF1','MacOS','Rocks','Sun','FreeBSD','Irix']
supportedPlatforms.sort()

Machines = FinitePreOrder.FinitePreOrder(machines)

def platformstring():
	plat = thisPlatform()
	s = plat
	pl = Platform().platforms(); pl.reverse()
	for x in pl: 
		if x!=plat: s = s + ', ' + x
	return s

_thisplatform = {}

def thisPlatform():
	if not _thisplatform.has_key('platform'):
		ppl = os.path.join(pac_anchor,pacmanDir,'ppl')
		if os.path.exists(ppl):
			try:
				f = open(ppl,'r')
				lines = f.readlines()
				f.close()
			except:
				abort("Can't read ["+ppl+"].")
			
			if len(lines)>0 and len(lines[0])>0:
				plat = string.strip(lines[0][:-1])
			else:
				abort("File ["+ppl+"] has been corrupted.")
		else:
			pre,plat = switchpar('pretend-platform')
			if not pre:
				if len(switchItems('pretend-platform'))>0:
					plat = switchItems('pretend-platform')[0]
				else:
					ok,u = uname()
					if ok and len(u)>0 and u[0]=='OSF1':
						if len(u)>=3:
							plat='OSF1-'+u[2][:2]
						else:
							plat = 'OSF1'
					else:
			 			plat = findPlatform()[0]
			if mtrans.has_key(plat): plat = mtrans[plat]
	
		got_one = 0
		for x,y in machines: 
			if plat==x or plat==y: got_one = 1; break
		if not got_one: plat = '*'
		_thisplatform['platform'] = plat
	else:
		plat = _thisplatform['platform']
	return plat

def platformDisplay():
	p = Platform()
	
	print '='
	sys.stdout.write('= Supported Architectures: '); niceListOut(supportedPlatforms); sys.stdout.write('\n')
	print '='
	print ' '
	for sup in supportedPlatforms:
		l = []
		for plat in Machines.items():
			if Machines.le(plat,sup): l.append(plat)
#		sys.stdout.write('- Supported Architecture ['+sup+']:')
		sys.stdout.write(sup+':')
		sort(l,lambda x,y: string.lower(x)<=string.lower(y))
		sys.stdout.write(' { ')
		niceListOut(l)
		sys.stdout.write(' }')
		sys.stdout.write('\n')
		print ' '
#	print ' '
	sys.stdout.write('- Your platform ')
	platSat(p.str())
	
def platSat(plat):
	p = Platform(plat)
	sys.stdout.write('['+plat+'] satisfies: ')
	l = []
	for plat in Machines.items():
		if Machines.le(p.str(),plat): l.append(plat)
	sort(l,lambda x,y: x<=y)
	if len(l)==0: l.append('*')
	sys.stdout.write('{ ')
	niceListOut(l)
	sys.stdout.write(' }\n')

class Platform(Environment):
	type   = 'platform'
	title  = 'Platforms'
	action = 'test platform'
	
	def __init__(self,platform=thisPlatform()): 
		self._platform = platform
		
	def str(self): return self._platform
	def equal(self,x): return self._platform==x._platform
	
	def display(self,indent=0):
		print indent*' '+self.statusStr(),'Platform ['+self._platform+'].'
	def display2(self,indent=0):
		sys.stdout.write(indent*' ')
		sys.stdout.write('Your platform ['+self._platform+'] satisfies { ')
		l = []
		for plat in Machines.items():
			if Machines.le(self.str(),plat): l.append(plat)
		sort(l,lambda x,y: string.lower(x)<=string.lower(y))
		niceListOut(l)
		sys.stdout.write(' }\n')
	
	def platforms(self): return Machines.items()
	def platformClasses(self):
		c = Clusters(Machines.items())
		cl = c.cluster(lambda p,q: Machines.eq(p,q))
		return cl
		
	def supported(self): 
		return allow('unsupported-platforms') or exists(supportedPlatforms,lambda plat: Machines.le(self._platform,plat))
#-- Set
	def str(self): return self._platform
	def equal(self,p): return Machines.eq(self._platform,p._platform)

#-- Satisfiable
	def satisfiable(self): return Reason()
#	def satisfiable(self): return self.satisfied()
	def satisfied(self): 
		return Reason("["+self.str()+"] has not been attempted yet.",not self.acquired)
#		if Machines.le(self._platform,thisPlatform()): 
#			r = Reason()
#		else:
#			r = self.platformReason()
#		self.satset(r.ok())
#		return r
	def acquire(self):
#		if Machines.le(self._platform,thisPlatform()): 
		if Machines.eq(self._platform,thisPlatform()): 
			r = Reason()
		else:
			r = self.platformReason()
#		if r.ok(): self.lastsat = 1
		self.satset(r.ok())
		return r
	def retract(self): return Reason()
	
	def name(self): return self._platform
	def platformReason(self): return Reason('Your os is ['+thisPlatform()+'] but it must satisfy ['+self.name()+'].')

#-- SatisfyOrder
	def satisfies(self,p):
		if self.type[:8]==p.type[:8]:
			if    p.type=='platform'   : s = Machines.eq(self._platform,p._platform)
			elif  p.type=='platform <=': s = Machines.ge(self._platform,p.value)
			elif  p.type=='platform <' : s = Machines.gt(self._platform,p.value)
			elif  p.type=='platform >=': s = Machines.le(self._platform,p.value)
			elif  p.type=='platform >' : s = Machines.lt(self._platform,p.value)
			else:  abort('Error in Platform.')
		else:
			s = 0
		return s
				
class PlatformLE(StringAttr):
	type   = 'platform <='
	title  = 'Platform <=s'
	action = 'platform <='

	def satisfied(self): 
		r = Reason('Your os is ['+thisPlatform()+'] but it must be <= ['+self.value+'].',not Machines.ge(thisPlatform(),self.value) )
		self.satset(r.ok())
#		if r.ok(): lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()
	
class PlatformLT(StringAttr):
	type   = 'platform <'
	title  = 'Platform <s'
	action = 'platform <'
	
	def satisfied(self): 
		r = Reason('Your os is ['+thisPlatform()+'] but it must be < ['+self.value+'].',not Machines.gt(thisPlatform(),self.value) )
		self.satset(r.ok())
#		if r.ok(): self.lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()
	
class PlatformGE(StringAttr):
	type   = 'platform >='
	title  = 'Platform >=s'
	action = 'platform >='
	
	def satisfied(self): 
		r =  Reason('Your os is ['+thisPlatform()+'] but it must be >= ['+self.value+'].',not Machines.le(thisPlatform(),self.value))
		self.satset(r.ok())
#		if r.ok(): self.lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()
	
class PlatformGT(StringAttr):
	type   = 'platform >'
	title  = 'Platform >s'
	action = 'platform >'

	def satisfied(self): 
		r = Reason('Your os is ['+thisPlatform()+'] but it must be > ['+self.value+'].',not Machines.lt(thisPlatform(),self.value))
		self.satset(r.ok())
#		if r.ok(): self.lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()

def platformCheck():
	p = Platform()
	if not p.supported() and not (switch('help') or switch('h') or switch('-help') or switch('platforms') or switch('platform')):
		print '-'
		print '- Platform ['+p.str()+'] is not yet supported.'
		print '- Contact Pacman headquarters at http://physics.bu.edu/pacman/ to request a new platform.'
		print '- Use [% pacman -pretend-platform <platform>] to override.'
#		print '- Use [% pacman -allow unsupported-platforms] once to override.'
		print '-'
		sys.exit(1)
