#
#     Get list of remote files
#
import urllib2
from sgmllib import SGMLParser
from Base import *

class URLHelper(SGMLParser):
	def reset(self):
		SGMLParser.reset(self)
		self.urls = []
		
	def start_a(self,attrs):
		href = [v for k, v in attrs if k=='href']
		if href:
			self.urls.extend(href)
			
def urlFiles(path,dirs=0):
	reason = Reason()
	filenames = []
	verbo.log('http','About to open url directory ['+path+']...')
	try:
		sock = urllib2.urlopen(path)
		text = sock.read()
		sock.close()
	except AssertionError:
		abort("Internal Python error attempting to access ["+path+"].")
	except:
		reason = Reason("Can't access ["+path+"].")
	
	if reason.ok():
		parser = URLHelper()
		parser.feed(text)
		parser.close()
		
		for url in parser.urls:
			if len(url)>0 and not ( url[0]=='/' or contains(url,'?') or contains(url,'=') ):
				if url[-1]=='/':
					if dirs: filenames.append(url)
				else:
					filenames.append(url)
	return reason,filenames
