#
#	Copyright Saul Youssef, 2005
#
from Base            import *
from Environment     import *
from FileGetter      import *
from Execution       import *
from UniversalAccess import *
import urlparse
import time,os
import Untarzip

class Download(Environment):
	type   = 'download'
	title  = 'Downloads'
	action = 'download'
	
	def __init__(self,url,deletable=0):
		self._url = url
		self._download = '- unset -'
		self._deletable = deletable
#-- Set
	def equal(self,dd): return self._url == dd._url
		
	def str(self):
		if self._download == '- unset -':
			s = os.path.basename(self._url)+' from '+self._url
		else:
			s = os.path.basename(self._url)+' from '+self._url+' => '+self._download 
		if self._deletable: s = s + ' (deletable)'
		return s
	def downfile(self): return os.path.basename(self._url)
	def getDeletable(self):
		if hasattr(self,'_deletable'): return self._deletable
		else:                          return 1

#-- Compatible	
	def compatible(self,d): return Reason()
	
#-- Satisfiable 
	def satisfied(self): return Reason('['+self._url+'] has not yet been downloaded.',not self.acquired)

	def satisfiable(self):
		r = Reason()
		if not self._url==os.path.expanduser(self._url):
			r = Reason("Download ["+self._url+"] refers to a user home directory.")
		elif '$' in self._url and not allow('non-snapshottable-downloads'):
			r = Reason("Download ["+self._url+"] contains an environment variable and can't be resolved for snapshots or mirrors (see -allow to override).")
		return r

	def headtails(self):
		head,tail = os.path.split(os.path.expanduser(self._url))
		hts = []
		if   os.environ.has_key('PAC_CACHE_LOCATION'):
			prefix = os.environ['PAC_CACHE_LOCATION']
			if isURL(head): hts.append((                     head,tail,))
			else:           hts.append((os.path.join(prefix,head),tail,))
		else:
			hts.append((head,tail,))
		return hts

	def acquire(self):
		reason = self.satisfiable()
		if reason.ok():
			for head,tail in self.headtails():
				try:
					cwd = os.getcwd()
					accessor = UniversalAccess(head)
					if isURL(head): 
						reason = ask.re('down','OK to download ['+tail+'] from ['+urlparse.urlparse(head)[1]+']?')
						verbo.log('down','Downloading ['+tail+'] from ['+urlparse.urlparse(head)[1]+']...')
					else:         
						reason = ask.re('down','OK to download ['+tail+'] from ['+os.path.basename(head)+']?')
						verbo.log('down','Downloading ['+tail+'] from ['+os.path.basename(head)+']...')
					if reason.ok():
						reason = accessor.getFile(tail)
				except OSError:
					reason = Reason("Current directory does not exist.  Can't download.")
				if reason.ok(): 
#					self._download = fullpath(tail)
					self._download = os.path.abspath(os.path.expanduser(tail))
					break
		return reason
		
	def retract(self):
		reason = execute('rm -f '+self._download)
		if reason.ok(): self._download = '- unset -'
		return reason

class DownloadTime(Environment):
	type   = 'timed download'
	title  = 'Timed Download'
	action = 'time download'
	
	def __init__(self,url,maxtime):
		self._download = Download(url)
		self._maxtime = maxtime  # float
		self._time = 0.0
		self._url = url
		
	def equal(self,x): return self._download==x._download and self._maxtime==x._maxtime
	def str(self): 
		if self._time==0.0: return ' of '+self._download._url+' in at most '+('%g'%self._maxtime)+' seconds'
		else: return ' of '+self._download._url+' in '+('%g'%self._time)+' seconds, must be <= '+('%g'%self._maxtime)+' seconds'
	
	def satisfiable(self): return Reason()
	def satisfied(self):
		return Reason(`self`+' has not yet been attempted.',not self.acquired)
	def acquire(self):
		t1 = time.time()
		reason = self._download.satisfy()
		t2 = time.time()
		removeFile(self._download.downfile())
		self._time = t2 - t1
		if reason.ok():
			if t2-t1<=self._maxtime: pass
			else:
				reason = Reason(self._download.downfile()+' downloads in '+('%g'%self._time)+' but its not <= '+('%g'%self._maxtime)+' seconds.')
		return reason
	def retract(self):
		self._time = 0.0
		return Reason()

class DownloadUntarzip(Environment):
	type   = 'downloadUntarzip'
	title  = 'Download and Untar/zips'
	action = 'download and untar/zip'
	
	def __init__(self,url,enviro=''):
		self._url = url
		self._enviro = enviro
		self._download = Download(self._url)
		self._untar    = Untarzip.Untarzip(os.path.basename(self._url),self._enviro)
		
	def equal(self,x): return self._url==x._url and self._enviro==x._enviro
	def str(self): 
		if self._untar._env=='':
			return self._download.str()+' and untar/zip'
		else:
			if hasattr(self._untar,'_enviro') and hasattr(self._untar._enviro,'type'):
				return self._download.str()+' untar/zip with top directory ['+self._untar._enviro.str()+']'
			else:
				return self._download.str()+' untar/zip and set ['+self._untar._env+'] to top directory.'
	def display(self,indent=0):
		print indent*' '+self.statusStr()+' '+`self`
		if displayMode('tar'):
			for x in self._untar._contents:
				print (indent+8)*' '+x
		
	def satisfiable(self): return Reason()
	def satisfied  (self): return self._untar.satisfied()

	def acquire(self):
		nRetry = 0
#		mRetry = httpGetRetries()
		mRetry = 0  # turn of these retries as they just confuse users and don't work often enough.  S.Y. Feb. 2006
		while 1:
			reason = self._download.satisfy()
			if reason.ok(): 
				reason = self._untar.satisfy()
				removeFile(os.path.basename(self._url))
			if not reason.ok(): 
				self.retract()
			if not reason.ok() and not contains(`reason`,'non-standard character') and nRetry<mRetry:
				r = ask.re('retry','OK to retry ['+`self`+']?')
				if r.ok():
					nRetry = nRetry + 1
					verbo.log('retry',`self`+' has failed with the following error:')
					verbo.log('retry',`reason`)
					verbo.log('retry','Retrying '+`nRetry`+'/'+`mRetry`+'...')
					verbo.log('retry','Pausing ['+`httpGetPause()`+'] seconds first (see -retry help to adjust this)...')
					time.sleep(httpGetPause())
				else:
					reason = copy.deepcopy(r)
					break
			else:
				if nRetry>0: verbo.log('retry','Retry of ['+`self`+'] has succeeded...')
				break
			self._untar._tarpause = nRetry*5
		self._untar._tarpause = 0
		return reason
		
	def retract(self): 
		self._download.retract().require()
		self._download = Download(self._url)
		r = self._untar.retract()
		self._untar = Untarzip.Untarzip(os.path.basename(self._url),self._enviro)
		return r
		
	def verify(self): return self._untar.verify()
