#
#	Written by Nick Wang
#
#	Modified by Saul
#
import sys,os
from Platform import *
from Base     import *

class FreeDiskOSError(Exception):
    def __init__(self):
        pass

    def __str__(self):
        return 'Cannot handle the operating system type.'

def localmegs(path0):
    path = fullpath(path0)
    p = Platform()
    if sys.platform == 'win32':
        import win32file
        sectorsPerCluster, bytesPerSector, numFreeClusters, totalNumClusters = win32file.GetDiskFreeSpace(path)
        sectorsPerCluster = long(sectorsPerCluster)
        bytesPerSector    = long(bytesPerSector)
        numFreeClusters   = long(numFreeClusters)
        totalNumClusters  = long(totalNumClusters)

        return (numFreeClusters * sectorsPerCluster * bytesPerSector) / (1024*1024)

#    elif sys.platform == 'cygwin':
    elif p.satisfies(Platform('Darwin')):
    	return 999999
    elif p.satisfies(Platform('cygwin')):
        import string
        lines = os.popen('df -m '+path).readlines()
	try:
		val = int(string.split(lines[-1])[3])
	except IndexError:
		abort('Directory ['+path+'] does not exist.')
        return val
        
#    elif sys.platform in ['linux2', 'sunos5']:
    elif p.satisfies(Platform('linux')) or p.satisfies(Platform('sun')):
        import statvfs
        nfree_blocks = os.statvfs(path)[statvfs.F_BAVAIL]
        blocksize    = os.statvfs(path)[statvfs.F_BSIZE]
        return ((nfree_blocks/1000)*blocksize)/1000
#    elif p.satisfies(Platform('unix')):
    else:
        import statvfs
        nfree_blocks = os.statvfs(path)[statvfs.F_BAVAIL]
        blocksize    = os.statvfs(path)[statvfs.F_BSIZE]
        return ((nfree_blocks/1000)*blocksize)/1000
#    else:
#    	abort('Unknown platform ['+sys.platform+'].')
#        raise FreeDiskOSError

if __name__ == '__main__':
    print localmegs('.')


