#
#	Copyright, 2004, Saul Youssef
#
from Base        import *
from Environment import *
import UniversalAccess,Package,Registry,CD,Directory,Execution,Download,Platform
import Cache,SourceCache,InstallationCache,SnapshotCache,Home,Trust
import time

excluded = ['Packages','Cat','URLs','Current Directories','Choices','Unsetenvs','Change Usernames','User Messages',
  'File Copy Speeds','Moves','File Exists Onces','ORs','ANDs','Temporary Environment Variable','SetCWD']
  
def selectFun(E,f):
	sel = []
	if   E.type=='AND' or E.type=='OR':
		for e in E: sel.extend(selectFun(e,f))
	elif E.type=='lazy package':
		pass
	elif f(E):
		sel.append(E)
	return sel

def snap(e,identity):
	if   e.type=='package':
		r,environ = snap(e._environ,identity)
		E = copy.deepcopy(e)
		E._environ = copy.deepcopy(environ)
	elif e.type=='AND':
		r,E = Reason(),AND()
		for ee in e:
			r,ee2 = snap(ee,identity)
			if r.ok(): E.append(ee2)
			else: break
	elif e.type=='OR':
		r,E = Reason,OR()
		for ee in e:
			r,ee2 = snap(ee,identity)
			if r.ok(): E.append(ee2)
			else: break
	elif e.type=='download':
#		downloadIdentity = fileify(e._url+'-'+time.ctime(time.time()))
		downloadIdentity = `abs(hash(e._url+'-'+time.ctime(time.time())))`
		downdir = os.path.join(pac_anchor,pacmanDir,'downloads',identity,downloadIdentity)
		r = Execution.execute('rm -r -f '+downdir+'; mkdir '+downdir)
		if r.ok(): 
			cwd = os.getcwd()
			os.chdir(downdir)
			down = copy.deepcopy(e)
			verbo.log('snap','Adding ['+e._url+'] to snapshot...')
			r = down.satisfy()
			os.chdir(cwd)
		E = copy.deepcopy(e)
		E._url = os.path.join('$PAC_ANCHOR',pacmanDir,'snapshots',identity,downloadIdentity,os.path.basename(e._url))
	elif e.type=='downloadUntarzip':
#		downloadIdentity = fileify(e._download._url+'-'+time.ctime(time.time()))
		downloadIdentity = `abs(hash(e._download._url+'-'+time.ctime(time.time())))`
		downdir = os.path.join(pac_anchor,pacmanDir,'downloads',identity,downloadIdentity)
		r = Execution.execute('rm -r -f '+downdir+'; mkdir '+downdir)
		if r.ok():
			cwd = os.getcwd()
			os.chdir(downdir)
			down = copy.deepcopy(e._download)
			verbo.log('snap','Adding ['+e._download._url+'] to snapshot...')
			r = down.satisfy()
			os.chdir(cwd)
		E = copy.deepcopy(e)
		E._download._url = os.path.join('$PAC_ANCHOR',pacmanDir,'snapshots',identity,downloadIdentity,os.path.basename(e._download._url))
	else:
		r,E = Reason(),e
	return r,E
	
def extractDownPackage(e):
	if    e.type=='package': 
		extractDownPackage(e._environ)
	elif  e.type=='AND' or e.type=='OR':
		for ee in e: extractDownPackage(ee)
	elif e.type=='download':
		if os.path.exists(os.path.basename(e._url)) and not allow('extract-downloads-overwrite'):
			print 'WARNING: ['+os.path.basename(e._url)+'] already exists.'
			if yesno('Download and overwrite anyway?'): e.satisfy().require()
		else:
			e.satisfy().require()
	elif e.type=='downloadUntarzip':
		if os.path.exists(os.path.basename(e._download._url)) and not allow('extract-downloads-overwrite'): 
			print 'WARNING: ['+os.path.basename(e._download._url)+'] already exists.'
			if yesno('Download and overwrite anyway?'): e._download.satisfy().require()
		else:
			e._download.satisfy().require()
		
class UniversalCache(Cache.Cache):
	def __init__(self,UCL):
		if 0 and contains(UCL,'..'): cn = fullpath(UCL)
		else:                  cn = UCL
		self.UCL = cn
		
		if                                  cn==          'null': self._cache = Cache.NullCache                        ()
		elif                                cn==          'home': self._cache = Home.Home                              ()
		elif                                cn=='trusted.caches': self._cache = CacheList          ('trusted.caches',0,1)
		elif                                tail(cn,'.snap'    ): self._cache = SnapshotCache.SnapshotCache          (cn)
		elif                                tail(cn,'.caches'  ): self._cache = CacheList                            (cn)
		elif os.path.isdir(os.path.join(fullpath(cn),pacmanDir)): self._cache = InstallationCache.InstallationCache  (cn)
		else                                                    : self._cache = SourceCache.SourceCache              (cn)
		self.type = self._cache.type
		
	def display (self,indent=0    ):        self._cache.display (     indent)
	def getAll  (self,spec,used   ): return self._cache.getAll  (  spec,used)
	def put     (self,package     ): return self._cache.put     (    package) 
	def remove  (self,spec        ): return self._cache.remove  (       spec)
	def contents(self,used        ): return self._cache.contents(       used)
	def snapshot(self,outfile2=''):
#		identity = fileify(self.UCL+'-'+time.ctime(time.time()))
		identity = `abs(hash(self.UCL+'-'+time.ctime(time.time())))`
		if outfile2=='': outfile = identity+'.snap'
		else:            outfile = outfile2
		
		if   len(switchItems('o'  ))>0:
			outfile = switchItems('o')[0]
		elif len(switchItems('out'))>0:
			outfile = switchItems('out')[0]
		
		snapdir = os.path.join(pac_anchor,pacmanDir,'downloads',identity)
#		r,ps = self.getAll(Package.Spec(),[])
		r,ps = self.contents([])
		if r.ok():
			verbo.log('snap','Creating snapshot of ['+self.UCL+']...')
			if r.ok(): r = Execution.execute('rm -r -f '+snapdir)
			if r.ok(): r = Execution.execute('mkdir '   +snapdir)
			if r.ok():
				qs = []
				for p in ps:
					if p.lastsat or p.lastfail:
						r = Reason("Can't snapshot installed package ["+p.str()+"].")
						break
					p._parents   = []
					p._modifiers = []
					p._neutered  =  0
					p.lastsat    =  0
					p.lastfail   =  0
					r,q = snap(p,identity)
					if r.ok(): qs.append(q)
					else: break
				if r.ok():
					f = open(os.path.join(snapdir,'identity'),'w')
					f.write(identity+'\n')
					f.write(self.UCL+'\n')
					f.write(time.ctime(time.time())+'\n')
					f.write(getusername()+'\n')
					f.write(pac_anchor+'\n')
					f.write(`Platform.Platform()`+'\n')
					f.write(version+'\n')
					f.close()
					f = open(os.path.join(snapdir,'packages'),'w')
					cPickle.dump(qs,f)
					f.close()
				if r.ok(): r = Execution.execute('cd '+os.path.join(pac_anchor,pacmanDir,'downloads')+'; tar cf '+outfile+' '+identity)
				if r.ok(): r = Execution.execute('cd '+os.path.join(pac_anchor,pacmanDir,'downloads')+'; mv '+outfile+' ../../')
				if r.ok(): r = Execution.execute('cd '+os.path.join(pac_anchor,pacmanDir,'downloads')+'; rm -r -f '+identity)
		return r
	def extractSources(self):
		r,ps = self.getAll(Package.Spec(),[])
		r.require()
		count = 0
		for p in ps:
			count = count + 1
			filename = p._spec.file
			if filename=='': filename = 'no-file-name-'+`count`
			if os.path.exists(filename): abort('File ['+filename+'] already exists.')
			f = open(filename,'w')
			for line in p._sourceCode: f.write(line)
			f.close()
		return r
	def extractDownloads(self):
		r,ps = self.getAll(Package.Spec(),[])
		r.require()
		for p in ps: extractDownPackage(p)
		return r
	def domain(self):
		r,ps = self.getAll(Package.Spec(),[])
		r.require()
		
		if r.ok():
			atoms = []
			if domainMode('all'):
				for p in ps: atoms.extend(selectFun(p._environ,lambda e:          1))
			else:
				for p in ps: atoms.extend(selectFun(p._environ,lambda e: e.acquired))
			
			cl = Clusters(atoms)
			def equiv(a,b): return a.title==b.title
			def leq(x,y): return x[0].title<=y[0].title
			classes = cl.cluster(equiv)
			sort(classes,leq)
			for c in classes:
				if domainMode('all') or not c[0].title in excluded:
					sort(c,lambda x,y: string.lower(x.str())<=string.lower(y.str()))
					print '- '+c[0].title+' - '
					for x in c: x.display(8)
		return r

class CacheList(List,Cache.Cache):
	def __init__(self,UFL,wrap=1,alwaysRefresh=0):
		self.UCL      = UFL
		self.type     = 'list'
		self._UFL     = UniversalAccess.UniversalFile(UFL)
		self._caches  = []
		self._ok      = 0
		self._wrap  = wrap
		self._refresh = alwaysRefresh
		self._lines   = []
#-- List	
	def __len__(self): return len(self._caches)
	def __getitem__(self,i): return self._caches[i]
	def append(self,cache): self._caches.append(cache)
	def pop(self,i): return self._caches.pop(i)

	def display(self,indent=0):
		print indent*' '+`self`
		r = self.init()
		if r.ok():
			for cache in self: cache.display(indent+4)
		else:
			print indent*' '+'    '+`r`

	def init(self):
		r = Reason("Can't access ["+`self`+"].",not self._UFL.access())
		if r.ok() and not self._ok or self._refresh:
			r,self._lines = self._UFL.getLines()
			self._caches = []
			if r.ok():
				for line in self._lines:
					if len(line)>0 and line[-1]=='\n': line = line[:-1]
					if not (len(line)==0 or string.strip(line)=='' or line[0]=='#'):
						if not line=='trusted.caches':
							cache = UniversalCache(line)
							self._caches.append(cache)
				self._ok = 1
			else:
				r = Reason("Can't find ["+`self`+"].")
		return r

	def refresh(self): 
		self._ok = 0
		return self.init()
		
	def getAll (self,spec,used): return self.getAllBase(spec,used,'quit')
	def getAllL(self,spec,used): return self.getAllBase(spec,used,'cont')
	
	def contents(self,used):
		r,ps = self.init(),[]
		if r.ok(): r = allReason(self._caches,lambda cache: Trust.trust.add(cache.UCL))
		if r.ok():
			for cache in self:
				r2,ps2 = cache.contents(used)
				r.append(r2)
				if r2.ok(): ps.extend(ps2)
			for p in ps: p._spec.caches.insert(0,self.UCL)
		return r,ps
		
	def getAllBase(self,spec,used,mode='quit'):
		r,ps = allReason(spec.caches,lambda cache: Trust.trust.add(cache)),[]
		if r.ok(): r = self.init()
		if r.ok(): r,used = self.check(spec,used)
		if r.ok() and len(self)==0: r = Reason("Cache ["+self.UCL+"] is empty.")
		if r.ok():
			r = AllReason(); r.headline = "Can't find ["+spec.str()+"] in ["+self.UCL+"]:"
			for cache in self:
				spec2,used2 = copy.deepcopy(spec),used[:]
				if len(spec2.caches)>0 and Registry.registry.equiv(spec2.caches[0],cache.UCL):
					rr,ps = spec2.getAll(used2)
					r.append(rr)
					if rr.ok() and contains(mode,'quit'):
						r = rr
						break
				else:
					rr,ps = cache.getAll(spec2,used2)		
					r.append(rr)
					if rr.ok() and contains(mode,'quit'):
						r = rr
						break
		return r,ps

	def put(self,package): return existsReason(self,lambda cache: cache.put(package))
