#
#	Copyright, Saul Youssef, January 2004
#
from StringAttr import *
import commands

def sshversion():
	if fileInPath('ssh'):
		status,output = commands.getstatusoutput('ssh -V')
		if status==0:
			l = string.split(output,',')
			if len(l)>1: 
				ll = string.split(l[0],'_')
				if len(ll)>=2:
					return ll[1]
				else:
					return '- unknown ssh version -'
			else:
				return '- unknown ssh version -'
		else:
			return '- unknown ssh version -'
	else:
		return '- no ssh in $path -'
		

class SSHVersion(StringAttr):
	type   = 'ssh version'
	title  = 'Python Versions'
	action = 'ssh version'
			
	def satisfied  (self): 
		pv = sshversion()
		if pv=='- no ssh in $path -':
			return Reason("[ssh] is not in the installer's path.")
		else:
			return Reason('ssh version is ['+sshversion()+']. It must be ['+self.value+'].',not sshversion() == self.value)	
	def satisfiable(self): return self.satisfied()	

	def acquire(self): return self.satisfied()
	def restore(self): return Reason()	
	
class SSHVersionLE(SSHVersion):
	type   = 'ssh version <='
	title  = 'ssh version <=s'
	action = 'ssh version <='
	
	def satisfied(self): 
		pv = sshversion()
		if pv=='- no ssh in $path -':
			return Reason("[ssh] is not in the installer's path.")
		else:
			return Reason('ssh version ['+sshversion()+'] must be <= ['+self.value+'].',not sshversion() <= self.value) 
	
class SSHVersionLT(SSHVersion):
	type   = 'ssh version <'
	title  = 'ssh version <s'
	action = 'ssh version <'
	
	def satisfied(self):
		pv = sshversion()
		if pv=='- no ssh in $path -':
			return Reason("[ssh] is not in the installer's path.")
		else:
 			return Reason('ssh version ['+sshversion()+'] must be < ['+self.value+'].',not sshversion() < self.value) 
	
class SSHVersionGE(SSHVersion):
	type   = 'ssh version >='
	title  = 'ssh version >=s'
	action = 'ssh version >='
	
	def satisfied(self): 
		pv = sshversion()
		if pv=='- no ssh in $path -':
			return Reason("[ssh] is not in the installer's path.")
		else:
			return Reason('ssh version ['+sshversion()+'] must be >= ['+self.value+'].',not sshversion() >= self.value) 
	
class SSHVersionGT(SSHVersion):
	type   = 'ssh version >'
	title  = 'ssh version >s'
	action = 'ssh version >'
	
	def satisfied(self): 
		pv = sshversion()
		if pv=='- no ssh in $path -':
			return Reason("[ssh] is not in the installer's path.")
		else:
			return Reason('ssh version ['+sshversion()+'] must be > ['+self.value+'].',not sshversion() > self.value) 
