#
#	Copyright, Saul Youssef, August 2003
#
from StringAttr import *
import commands

def pythonversion():
	if fileInPath('python'):
		status,output = commands.getstatusoutput('python -V')
		if status==0:
			l = string.split(output,' ')
			if len(l)>1:
				if l[0]=='Python': return l[1]
				else: 
					return '- unknown python version -'
			else: 
				return '- unknown python version -'
		else: 
			return '- unknown python version < 2.0 -'
	else:
		return '- no python in $path -'

class PythonVersion(StringAttr):
	type   = 'python version'
	title  = 'Python Versions'
	action = 'python version'
			
	def str(self): return 'must be equal to ['+self.value+'], actually ['+pythonversion()+'].'
	def satisfied  (self): 
		pv = pythonversion()
		if pv=='- no python in $path -':
			return Reason("[python] is not in the installer's path.")
		else:
			return Reason('python version is ['+pythonversion()+']. It must be ['+self.value+'].',not pythonversion() == self.value)	
	def satisfiable(self): return self.satisfied()	

	def acquire(self): return self.satisfied()
	def restore(self): return Reason()
	
class PythonVersionLE(PythonVersion):
	type   = 'python version <='
	title  = 'python version <=s'
	action = 'python version <='
	
	def str(self): return '['+self.value+'], actually ['+pythonversion()+'].'
	def satisfied(self): 
		pv = pythonversion()
		if pv=='- no python in $path -':
			return Reason("[python] is not in the installer's path.")
		else:
			return Reason('python version ['+pythonversion()+'] must be <= ['+self.value+'].',not pythonversion() <= self.value) 
	
class PythonVersionLT(PythonVersion):
	type   = 'python version <'
	title  = 'python version <s'
	action = 'python version <'
	
	def str(self): return '['+self.value+'], actually ['+pythonversion()+'].'
	def satisfied(self):
		pv = pythonversion()
		if pv=='- no python in $path -':
			return Reason("[python] is not in the installer's path.")
		else:
 			return Reason('python version ['+pythonversion()+'] must be < ['+self.value+'].',not pythonversion() < self.value) 
	
class PythonVersionGE(PythonVersion):
	type   = 'python version >='
	title  = 'python version >=s'
	action = 'python version >='
	
	def str(self): return '['+self.value+'], actually ['+pythonversion()+'].'
	def satisfied(self): 
		pv = pythonversion()
		if pv=='- no python in $path -':
			return Reason("[python] is not in the installer's path.")
		else:
			return Reason('python version ['+pythonversion()+'] must be >= ['+self.value+'].',not pythonversion() >= self.value) 
	
class PythonVersionGT(PythonVersion):
	type   = 'python version >'
	title  = 'python version >s'
	action = 'python version >'
	
	def str(self): return '['+self.value+'], actually ['+pythonversion()+'].'
	def satisfied(self): 
		pv = pythonversion()
		if pv=='- no python in $path -':
			return Reason("[python] is not in the installer's path.")
		else:
			return Reason('python version ['+pythonversion()+'] must be > ['+self.value+'].',not pythonversion() > self.value) 
