from StringAttr import *
import commands
		
def perlversion():
	if fileInPath('perl'):
		status,output = commands.getstatusoutput('perl -v')
		if status==0:
			l = string.split(output,' ')
			v = '- unknown perl version -'
			for x in l:
				if len(x)>3:
					if x[0]=='v' and '.' in x: v = x[1:]; break
			return v
	else:
		return '- no perl in $path -'

class PerlVersion(StringAttr):
	type   = 'perl version'
	title  = 'Perl Versions'
	action = 'perl version'
			
	def str(self): return 'must be equal to ['+self.value+'], actually ['+perlversion()+'].'
	def satisfied  (self): 
		pv = perlversion()
		if pv=='- no perl in $path -':
			return Reason("[perl] is not in the installer's path.")
		else:
			return Reason('perl version is ['+perlversion()+']. It must be ['+self.value+'].',not perlversion() == self.value)	
	def satisfiable(self): return self.satisfied()	

	def acquire(self): return self.satisfied()
	def restore(self): return Reason()
	
class PerlVersionLE(PerlVersion):
	type   = 'perl version <='
	title  = 'perl version <=s'
	action = 'perl version <='
	
	def str(self): return '['+self.value+'], actually ['+perlversion()+'].'
	def satisfied(self): 
		pv = perlversion()
		if pv=='- no perl in $path -':
			return Reason("[perl] is not in the installer's path.")
		else:
			return Reason('perl version ['+perlversion()+'] must be <= ['+self.value+'].',not perlversion() <= self.value) 
	
class PerlVersionLT(PerlVersion):
	type   = 'perl version <'
	title  = 'perl version <s'
	action = 'perl version <'
	
	def str(self): return '['+self.value+'], actually ['+perlversion()+'].'
	def satisfied(self):
		pv = perlversion()
		if pv=='- no perl in $path -':
			return Reason("[perl] is not in the installer's path.")
		else:
 			return Reason('perl version ['+perlversion()+'] must be < ['+self.value+'].',not perlversion() < self.value) 
	
class PerlVersionGE(PerlVersion):
	type   = 'perl version >='
	title  = 'perl version >=s'
	action = 'perl version >='
	
	def str(self): return '['+self.value+'], actually ['+perlversion()+'].'
	def satisfied(self): 
		pv = perlversion()
		if pv=='- no perl in $path -':
			return Reason("[perl] is not in the installer's path.")
		else:
			return Reason('perl version ['+perlversion()+'] must be >= ['+self.value+'].',not perlversion() >= self.value) 
	
class PerlVersionGT(PerlVersion):
	type   = 'perl version >'
	title  = 'perl version >s'
	action = 'perl version >'
	
	def str(self): return '['+self.value+'], actually ['+perlversion()+'].'
	def satisfied(self): 
		pv = perlversion()
		if pv=='- no perl in $path -':
			return Reason("[perl] is not in the installer's path.")
		else:
			return Reason('perl version ['+perlversion()+'] must be > ['+self.value+'].',not perlversion() > self.value) 
