#
#   Copyright 2004, Saul Youssef
#
#   Pacman fetches, installs, configures and sets up software
#
#   See http://physics.bu.edu/pacman/ for more information.
#
try:
	import sys,os,pythonCheck
	pythonCheck.pythonCheck()

	import commandCheck
	commandCheck.commandCheck()

	import lock
	lock.lock()

	from Base import *
	from Environment import *
	import Home,Package,UniversalCache,Platform,Execution,Registry,Trust
	
	r = Reason()
	home = Home.Home()
	
	if (switch('lc') or switch('domain') or switch('extract-sources') or switch('extract-downloads')) and \
	    not (switch('snap') or switch('get') or switch('install') or switch('fetch') or switch('update') or switch('remove')):
		topspecs = []
	else:
		topspecs = home.topSpecs()
	snapstring = '.snap'
	for param in switchItems('snap'):
		spec = Package.Spec(param)
		if snapstring[0]=='.': snapstring = spec.name+snapstring
		else:                  snapstring = spec.name+'_'+snapstring
	if snapstring[0]=='.' or len(switchItems('snap'))==0: 
		count = 0
		for spec in topspecs:
			if count>0: snapstring='_'+snapstring
			snapstring = spec.name+snapstring
			count = count + 1
	if snapstring[0]=='.': snapstring = 'empty'+snapstring

	def specPars(sw): 
		specs = []
		lastcaches = []
		for param in switchItems(sw):
			spec = Package.Spec(param)
			if not sw in ['uninstall','remove','remove-all'] and spec.caches==[]: spec.caches = lastcaches[:]
			specs.append(spec)
			if len(spec.caches)>0: lastcaches = spec.caches[:]
		return specs
	def specParT(sw):
		specs = specPars(sw)
		if len(specs)==0 and switch(sw): specs = topspecs
		return specs
		
	depth = displayModeDepth()
except KeyboardInterrupt:
	import lock
	lock.unlock()
	print '^C user interrupt.  No actions have been taken...'
	if '-debug' in sys.argv: raise
	sys.exit(1)
except MemoryError:
	import lock
	lock.unlock()
	print 'Not enough memory...'
	if '-debug' in sys.argv: raise
	sys.exit(1)

try:
	alreadySetup = os.path.exists('setup.csh')
	if switch('fetch') or switch('install') or switch('uninstall') or switch('remove') or switch('update') or switch('get') or switch('setup'): 
		removeFiles('setup.csh','setup.sh','setup.py','setup.pl')
	if switch( 'registry'): Registry.registry.display()
	if switch('platforms'): Platform.platformDisplay ()
	
	if switch('single'): adepth = 0
	else:                adepth = 999999
	
	if r.ok(): r = allReason(specPars(         'fetch'),lambda spec: Package.LazyPackage(spec).fetch            ())
	if r.ok(): r = allReason(specParT(       'install'),lambda spec: Package.LazyPackage(spec).satisfiable      ())
	if r.ok(): r = allReason(specParT(       'install'),lambda spec: Package.LazyPackage(spec).satisfy          ())
	if r.ok(): r = allReason(specParT(           'get'),lambda spec: Package.LazyPackage(spec).satisfiable      ())
	if r.ok(): r = allReason(specParT(           'get'),lambda spec: Package.LazyPackage(spec).satisfy          ())
	if r.ok(): r = allReason(specParT(     'installed'),lambda spec: Package.LazyPackage(spec).satisfied        ())
	if r.ok(): r = allReason(specParT(     'uninstall'),lambda spec: Package.LazyPackage(spec).uninstall  (adepth))
	if r.ok(): r = allReason(specParT(        'remove'),lambda spec: Package.LazyPackage(spec).remove     (adepth))
	if r.ok(): r = allReason(specParT(        'verify'),lambda spec: Package.LazyPackage(spec).setup            ())
	if r.ok(): r = allReason(specParT(        'verify'),lambda spec: Package.LazyPackage(spec).verify           ())
	if r.ok(): r = allReason(specParT(        'repair'),lambda spec: Package.LazyPackage(spec).repair           ())
	if r.ok(): r = allReason(specParT(  'update-check'),lambda spec: Package.LazyPackage(spec).updateCheck      ())
	if r.ok(): r = allReason(specParT(        'update'),lambda spec: Package.LazyPackage(spec).updateCheck      ())
	if r.ok(): r = allReason(specParT(        'update'),lambda spec: Package.LazyPackage(spec).update           ())
	if r.ok(): r = allReason(specParT( 'update-remove'),lambda spec: Package.LazyPackage(spec).updateRemove     ())

	if r.ok() and (switch('setup') or switch('get') or alreadySetup and switch('update')):
		e = AND()
		for spec in home.topSpecs(): e.append(Package.LazyPackage(spec))
		r = e.setup()
		if r.ok():
			os.chdir(home.UCL)
			removeFiles('setup.csh','setup.sh','setup.py','setup.pl')
			csh,sh,py,pl = open('setup.csh','w'),open('setup.sh','w'),open('setup.py','w'),open('setup.pl','w')
			shellHeader(csh,sh,py,pl)
			e.shellOut (csh,sh,py,pl)
			csh.close(); sh.close(); py.close(); pl.close()
			
	if r.ok() and (switch('removeall') or switch('remove-all')):
		for spec in home.topSpecs():
			r = Package.LazyPackage(spec).restore()
			if r.ok(): r = Package.LazyPackage(spec).remove()
			if not r.ok(): break
		r2 = home.refreshParents()
		if r.ok(): 
			removeFiles('setup.csh','setup.sh','setup.py','setup.pl','trusted.caches')
			os.chdir(home.UCL); home.save()
			Execution.execute('rm -r -f "'+pacmanDir+'"','x')
			r = r2

	if (switch('fetch') or switch('install') or switch('get') or switch('uninstall') and switch('l')): topspecs = home.topSpecs ( )
	if r.ok(): r = allReason(specParT('l'                    ),                lambda  spec: Package.LazyPackage(spec).displayM                  (depth))	
	if r.ok(): forall       (switchItems('lc'                ),                lambda cache:    UniversalCache.UniversalCache(cache).display          ())
	if r.ok() and switch('lc'  ) and len(switchItems('lc'  ))==0:                               UniversalCache.UniversalCache(  '.').display          ()
	if r.ok(): r = allReason(switchItems('snap'              ),                lambda cache:    UniversalCache.UniversalCache(cache).snapshot         (snapstring))
	if r.ok() and switch('snap') and len(switchItems('snap'))==0:                           r = UniversalCache.UniversalCache(  '.').snapshot         (snapstring)
	if r.ok(): r = allReason(switchItems('domain'            ),                lambda cache:    UniversalCache.UniversalCache(cache).domain           ())
	if r.ok() and switch('domain' ) and len(switchItems('domain'))==0:                      r = UniversalCache.UniversalCache(  '.').domain           ()
	if r.ok(): r = allReason(switchItems('extract-sources'   ),                lambda cache:    UniversalCache.UniversalCache(cache).extractSources   ())
	if r.ok() and switch('extract-sources') and len(switchItems('extract-sources'))==0:     r = UniversalCache.UniversalCache(  '.').extractSources   ()
	if r.ok(): r = allReason(switchItems('extract-downloads' ),                lambda cache:    UniversalCache.UniversalCache(cache).extractDownloads ())
	if r.ok() and switch('extract-downloads') and len(switchItems('extract-downloads'))==0: r = UniversalCache.UniversalCache(  '.').extractDownloads ()

except AbortException,message:
	lock.unlock()
	if switch('debug'): raise
	r = Reason(message.value)
except MemoryError:
	lock.unlock()
	if switch('debug'): raise
	r = Reason('Not enough memory for attempted operation.')
except TypeError:
	lock.unlock()
	if switch('debug'): raise
	r = Reason('Error in Pacman. Complain to Pacman Headquarters http://physics.bu.edu/pacman/.')
except AttributeError:
	lock.unlock()
	if switch('debug'): raise
	r = Reason('Error in Pacman. Complain to Pacman Headquarters http://physics.bu.edu/pacman/.')
except RuntimeError:
	lock.unlock()
	if switch('debug'): raise
	r = Reason('Looping packages.')
except KeyboardInterrupt:
	lock.unlock()
	if switch('debug'): raise
	print '^C user interrupt.  Saving work so far...'
	r = Reason()

os.chdir(home.UCL); home.save()
lock.unlock()

import switchFinalize
switchFinalize.switchFinalize()

if not r.ok() or switch('verify'): r.display()
commandCheck.saveCommand(r)

if r.ok(): sys.exit(0)
else:      sys.exit(1)



