#
#	Copyright, 2005, Saul Youssef
#
from Base        import *
from Environment import *
import Cache,Source,CD,CWD,Directory,UniversalCache,Home,EnvironmentVariable,Registry
import os,copy,string

def reduceCaches(E,caches):
	if E.type=='AND':
		for e in E: reduceCaches(e,caches)
	elif E.type=='OR':
		for e in E: reduceCaches(e,caches)
	elif E.type=='lazy package':
		if sublistEQ(caches,E._spec.caches,lambda c1,c2: Registry.registry.equiv(c1,c2)):
			E._spec.caches = caches[:]
			
def prepend(e,cache):
	if e.type=='AND':
		for ee in e: prepend(ee,cache)
	elif e.type=='OR':
		for ee in e: prepend(ee,cache)
	elif e.type=='lazy package':
		e._spec.caches.insert(0,cache)

def prepend0(e,cache):
	if e.type=='AND':
		for ee in e: prepend0(ee,cache)
	elif e.type=='OR':
		for ee in e: prepend0(ee,cache)
	elif e.type=='lazy package':
		if len(e._spec.caches)==0: 
			e._spec.caches.insert(0,cache)
		
def specParse(text):
	caches = []
	front,back = specSplit(text)
	while not back=='':
		caches.append(front)
		front,back = specSplit(back)
	
	if not '|' in front:
		prefix = front; guardstring = ''
	else:
		prefix      = string.strip(front[:string.find(front,'|')   ])
		guardstring = string.strip(front[ string.find(front,'|')+1:])
		
	subdirectory,name = os.path.split(prefix)
	return caches,name,subdirectory,guardstring
		
def specSplit(text):
	front = ''; back = text
	while 1:
		if     len(back)==0: 
			break
		elif  back[:5]=='http:': 
			front = front + back[:5]
			back  =         back[5:]
		elif  back[:6]=='https:':
			front = front + back[:6]
			back  =         back[6:]
		elif  back[:4]=='ftp:':
			front = front + back[:4]
			back  =         back[4:]
		elif  back[:7] =='gsiftp:':
			front = front + back[:7]
			back  =         back[7:]
		elif  back[0]==':':
			back = back[1:]
			break
		else:
			front = front + back[:1]
			back  =         back[1:]
	return front,back

def cacheMatch(specs,cs):
	if   len(specs)==0: m = 1
	elif len(cs   )==0: m = 0
	else:
		if Registry.registry.equiv(specs[0],cs[0]):
			specs.pop(0); cs.pop(0)
			m = cacheMatch(specs,cs)
		else:
			cs.pop(0)
			m = cacheMatch(specs,cs)
	return m

class Spec(PreOrder,HtmlOut):
	def __init__(self,specstring='',location=''):
		self.specstring,self.location = specstring,location
		self.caches,self.name,self.subdirectory,self.guard = specParse(specstring)
		self.location = location
		self.lazyOK = 1
		self.file = ''
		if tail(self.name,'.pacman'):
			self.file = self.name
#			self.name = self.name[:-7]
			self.name = '' # self.name[:-7]
		if specstring=='.': self.name,self.cacheName = '','.'
		self.mayBeModifiedBy = ['']
			
	def _id (self): return `self.caches,self.name,self.subdirectory,self.file`
	def __eq__(self,x): return self.caches==x.caches and self.name==x.name and self.file==x.file and \
		self.subdirectory==x.subdirectory and self.caches==x.caches and \
		self.location==x.location
	def __le__(self,x):
		q = x.name=='*' or x.name=='' or x.name==self.name
		if q: q = x.subdirectory==''  or x.subdirectory==self.subdirectory
		if q: q = x.file==''          or x.file==self.file
		return q
	def match(self,caches):
		cs2 = self.caches[:]
		caches2 = caches [:]
		return cacheMatch(cs2,caches2)
	def satisfiedBy(self,p): return self.satisfiedByR(p).ok()
	def satisfiedByR(self,p):
		r = Reason()
		if self.match(p._spec.caches):
			q = p._spec<=self
			if q:
				if not self.guard=='':
#					r,guard = Source.Source(self.guard).comp()
					r,guard = Source.Source(self.guard,Spec()).comp()
					if r.ok():
						if not p._environ.satisfies(guard):
							r = Reason("Package specification ["+self.str()+"] fails |... requirements of ["+p._spec.str()+"].")
			else:
				r = Reason("Package specification ["+self.str()+"] not satisfied by ["+p._spec.str()+"].")
		else:
			r = Reason("Package specification ["+self.str()+"] does not match the caches of ["+p._spec.str()+"].")
		if verbo('ptest') and not self.name=='' and not self.name=='*':
			if r.ok(): print "Package specification ["+self.str()+"] satisfied by ["+p._spec.str()+"]."
			else:      print r
		return r
	def __repr__(self): return 'spec: '+self.str()
	def str(self): 
		s = ''
		for cache in self.caches:  s = s + cache + ':'
		if self.subdirectory !='': s = s + self.subdirectory + '/'
		s = s + self.name
		if self.guard        !='': s = s + ' | '+self.guard
		if self.location     !='': s = s + ' at '+self.location
		return s
	def filenameEqu(self,filename):
		if self.name=='*': 
			comp = 1
		else:
			fname = os.path.basename(filename)
			comp = 0
			if tail(fname,'.pacman'):
				if self.file =='': comp = self.name==fname[:len(self.name)]
				else:              comp = fname==self.file
		return comp
	def envEqu(self,e): return e.satisfies(Source.Source(self.guard).compile())
	def locate(self,e):
		if self.location=='': 
			e2 = AND(CWD.SetCWD('.'),EnvironmentVariable.SetenvTemp('PACMAN_INSTALLATION','.'))
			e2.extend(e)
			e2.append(CWD.SetCWD('.'))
		else:
			e2 = AND(Directory.Directory(self.location),CWD.SetCWD(self.location))
			e2.extend(e)
			e2.extend(CWD.SetCWD('.'))
		return e2
	def getAll(self,used=[]):
		r,ps = Reason(),[]
		spec = copy.deepcopy(self)
		
		if len(spec.caches)==0: r = Reason("Can't find ["+spec.str()+"].")
		if r.ok():
			c = UniversalCache.UniversalCache(spec.caches.pop(0))
			r,ps = c.getAll(spec,used)
			for p in ps:
				if c.type=='source': prepend0(p._environ,c.UCL)
				else:                prepend (p._environ,c.UCL)
				p._spec.caches.insert(0,c.UCL)
		if len(ps)==0: r = Reason('Package ['+self.str()+'] not found.')
		return r,ps
	def get(self):
		r,ps = self.getAll([])
		if r.ok() and len(ps)>0: return r,ps[0]
		else:                    return r,Package()
	def put(self,package):
		if len(self.caches)==0:
			r = Reason("Can't save ["+package.str()+"].")
		else:
			c = UniversalCache.UniversalCache(self.caches[0])
			r = c.put(package)
		return r
		
class Update:
	_updateChecked = 0
	_updated       = 0
	def updateCheck   (self): abort('missing updateCheck'           )
	def updateWaiting (self): abort('missing updateWaiting'         )
	def updateRemove  (self): abort('missing updateRemove'          )
	def update        (self): abort('missing update function.'      )

class Verify:
	def verify        (self): abort('missing verify function.'      )
	def repair        (self): abort('missing repair function.'      )
	
class Package(Environment,Update,Verify):
	type   = 'package'
	title  = 'Packages'
	action = 'install package'
	
	def __init__(self,spec=Spec(),cache='trust.caches',environ=OR()):
		self._spec        = spec
		self._inCache     = ''
		self._environ     = environ
		self._source      = AND()
		self._sourceCode  = []
		self._sourceCache = ''
		for e in environ: 
			ee = copy.deepcopy(e)
			self._source.append(ee)
		self._update           = OR()
		self._updateSourceCode = []
		
		self._lazy = 0
		self._parents   = []
		self._modifiers = []
		
		self._neutered = 0
		self._lastSatisfiable = Reason()
		
	def _id(self): return `self._spec.name,self._sourceCache,self._spec.subdirectory,self._spec.file`
#-- Set
	def equal(self,p):                     return \
		self._spec        == p._spec      and \
		self._environ     == p._environ   and \
		self._source      == p._source 
	def str(self): return self._spec.str()
	def location(self):
		if len(self._environ)>0 and self._environ[0].type=='setcwd':
			return self._environ[0].location
		else:
			return '.'
#-- Applies
	def status(self):
		if debug('status'):
			installed   = self.satisfied     ().ok()
			installable = self.satisfiable   ().ok()
			update      = self.updateWaiting ().ok()
			loc         = self.location()
		else:
			installed   =     self.lastsat
			installable = installed or (self._lastSatisfiable.ok() and not self.lastfail)
			update      =     self.updateWaiting().ok()
			loc         =     self.location()
		return installable,installed,update,loc
	def getEs(self,typename):
		es = []
		def f(E):
			if E.type=='AND' or E.type=='OR':
				for e in E: f(e)
			elif E.type=='lazy package': 
				pass
			else:
				if E.type==typename: es.append(E)
		f(self._environ)
		return es
	def display(self,indent=0,tail=''): 
		installable,installed,update,loc = self.status()

		s = ''
		if         installed: s = s + '[*]'
		elif not installable: s = s + '[X]'
		else:                 s = s + '[ ]'
		t = ''
		if update: t = ' ==> UPDATE AVAILABLE '

		if not ( displayMode(        'req') or \
			 displayMode(         'up') or \
			 displayMode(         'in') or \
			 displayMode(     'subdir') or \
			 displayMode(        'src') or \
			 displayMode(       'file') or \
			 displayMode(        'loc') or \
			 displayMode(        'rel')  ):
			s = s + ' ' + os.path.join(self._spec.subdirectory,self._spec.name)+', in cache ['+self._inCache+']'  #+', from ['+self._spec.file+']'
		else:
			s = s + ' ' + os.path.join(self._spec.subdirectory,self._spec.name)
			if displayMode(       'up'):
				s = s + ', update from ['
				count = 0
				for cache in self._spec.caches: 
					count = count + 1
					if count==len(self._spec.caches): s = s + cache
					else:                             s = s + cache+':'
				s = s + ']'
			if displayMode(       'req'): s = s + ' | ' + self._spec.guard
			if displayMode(        'in'): s = s + ', in cache ['+self._inCache+']'
			if displayMode(       'src'): s = s + ', source cache ['+self._sourceCache+']'
			if displayMode(    'subdir'): s = s + ', subdirectory ['+ self._spec.subdirectory+']'
			if displayMode(      'file'): s = s + ', from [' + self._spec.file+']'
			if displayMode(       'loc'): s = s + ', installation starting from ['+loc+']'
			if displayMode(       'rel') and self._neutered: s = s + ' <=(relative)= '+self.caches
			
		print indent*' '+s+t+tail
		if displayMode('config') and len(self._modifiers)>0: 
			s = ''
			for sp in self._modifiers: s = s + ' ' + sp.str()
			print indent*' '+'       configured by:'+s
		if displayMode(   'par') and len(self._parents  )>0:
			s = ''
			for sp in self._parents: s = s + ' ' + sp.str()
			print indent*' '+'       parents:'+s
		if displayMode('version'):
			for e in self._environ: 
				if e.type=='version' or e.type=='version tuple': 
					print indent*' '+'           '+`e`
		if displayMode('release'):
			for e in self._environ: 
				if e.type=='release': 
					print indent*' '+'           '+`e`
		if displayMode('description'):
			for e in self._environ:
				if e.type=='description':
					print indent*' '+'           '+`e`
		if displayMode('url'):
			for e in self._environ:
				if e.type=='url':
					print indent*' '+'           '+`e`
		if displayMode('tag'):
			for e in self._environ: 
				if e.type=='tag': 
					print indent*' '+'           '+`e`
		if displayMode('patch'):
			for e in self._environ:
				if e.type=='patch':
					print indent*' '+'           '+`e`
		if displayMode('option'):
			for e in self._environ:
				if e.type=='option':
					print indent*' '+'           '+`e`
		if   displayMode('src'):
			for line in       self._sourceCode: print indent*' '+'         [src] '+line[:-1]
		if displayMode('cmp'):
			self._environ.display(indent+8)
		if displayMode('ups'):
			for line in self._updateSourceCode: print indent*' '+'         [ups] '+line[:-1]

	def displayM(self,depth=99999,indent=0):
		if depth==0: self.display(indent,'...')
		else:        self.display(indent)
		if depth>0: self._environ.displayM(depth-1,indent+4)
		return Reason()

	def locateRefresh(self):
		if len(self._environ)>0 and self._environ[0].type=='mkdir': self._spec.location = self._environ[0].str()
	def parents  (self): return self._parents
	def modifiers(self): return self._modifiers

#-- Environment
	def reasonFixup(self,r,action='installed'):
		if not r.ok():
			if hasattr(r,'headline'):
				if r.headline=='':
					rr = copy.deepcopy(r)
					rr.headline = 'Package ['+self.str()+'] not ['+action+']:'
				else:
					rr = AllReason()
					rr.headline = 'Package ['+self.str()+'] not ['+action+']:'
					rr.append(r)
			else:
				rr = AllReason()
				rr.headline = 'Package ['+self.str()+'] not ['+action+']:'
				rr.append(r)
		else:
			rr = r
		return rr
			
	def satisfied(self): 
		r = self._environ.satisfied()
		if r.ok(): 
			self.lastsat  = 1
		else:      
			self.lastfail = 1
		return self.reasonFixup(r)
	def satisfiable(self): 
		self._lastSatisfiable = self._environ.satisfiable()
		return self.reasonFixup(self._lastSatisfiable,'installable')
	def fetch(self):
		self._lastSatisfiable = self._environ.fetch()
		return self.reasonFixup(self._lastSatisfiable,'installable')
	def satisfy(self):
		verbo.log('pac','About to begin installing ['+self._spec.str()+']...')
		r = ask.re('pac','OK to begin installing ['+self._spec.str()+']?')
		if r.ok():
			if self._neutered:
				r = self.setup()
				if not r.ok():
					r.display()
					r = Reason("Package ["+self.str()+"] not installed at remote installation.")
					self.lastfail = 1
				else:
					self.lastsat  = 1
			else:
				r = self._environ.satisfy()
				if r.ok(): self.lastsat  = 1
				else:      self.lastfail = 1
				
				if r.ok(): 
					verbo.log('pac','Package ['+self._spec.str()+'] successfully installed...')
					r = ask.re('pac','Package ['+self._spec.str()+'] has been successfully installed. Keep going?')
				else:      
					verbo.log('pac','Package ['+self._spec.str()+'] installation attempt has failed...')
		return self.reasonFixup(r)
	def setup(self): 
		idd = self._id()
		if not _setupBody.has_key(idd):
			debug.log('setup','Package ['+self._spec.str()+'] is being setup...')
			r = self._environ.setup()
			_setupBody[idd] = ''
		else:
			r = Reason()
		return self.reasonFixup(r)
	def restore(self):
		r = Reason()
		if not self._neutered:
			r = self._environ.restore()
			if r.ok():
				self.lastsat  = 0
				self.lastfail = 0
		return self.reasonFixup(r,'uninstalled')

#-- Verify
	def verify(self): return self.reasonFixup(self._environ.verify(),'verified')
	def repair(self): return self.satisfy  ()

#-- Install
	def uninstall(self,depth=0):
		r = Reason()
		if verbo('pac'): print 'About to begin uninstalling ['+self._spec.str()+']...'
		r = ask.re('pac','OK to begin uninstalling ['+self._spec.str()+']?')
		if r.ok():
			if self._neutered or depth<0:
				pass
			elif len(self._modifiers)>0:
				r = allReason(self._modifiers,lambda spec: LazyPackage(spec).uninstall())
			else:
				if self.lastsat and len(self.getEs('uninstall shell command'))>0: self.setup()
				r = self.uninstallBody(depth)
				if not switch('update'): self.uninstallSet()
			
			self.lastsat  = 0
			self.lastfail = 0
			
			if r.ok(): 
				if verbo('pac'): print 'Package ['+self._spec.str()+'] successfully uninstalled...'
				r = ask.re('pac','Package ['+self._spec.str()+'] has beed successfully uninstalled.  Keep going?')
			else:      
				verbo.log('pac','Package ['+self._spec.str()+'] uninstallation attempt has failed...')
		return self.reasonFixup(r,'uninstall')
	def uninstallBody(self,depth=0):
		def f(e):
			r = Reason()
			if e.type=='AND' or e.type=='OR':
				r = allReasonQB(e,lambda e: f(e))
			elif e.type=='lazy package':
				if exists(e.modifiers(),lambda mod: mod.satisfiedBy(self)): r = e.uninstallBody(depth  )
				elif depth>0:                                               r = e.uninstall    (depth-1)
			else:
				r = e.restore()
			return r
		r = allReasonQB(self._environ,lambda e: f(e))
		self.lastsat  = 0
		self.lastfail = 0
		return r
	def uninstallSet(self):
		self.lastsat  = 0
		self.lastfail = 0
		r = allReasonQB(self.parents(),lambda spec: LazyPackage(spec).uninstallSet())
		return r
	def remove(self,depth=0):
		r = Reason()
		if depth>=0:
			r = self.uninstall(0)
			if r.ok(): r = self.desave()
			if r.ok(): r = self.descend(depth)
			if r.ok(): r = UniversalCache.UniversalCache('home').remove(self._spec)
		return self.reasonFixup(r,'remove')
	def desave(self):
		def f(E):
			r = Reason()
			if E.type=='AND' or E.type=='OR': 
				r = allReason(E,lambda e: f(e))
			elif E.type=='restore':           
				r = E.removeSave()
			return r
		return f(self._environ)
	def descend(self,depth=0):
		def f(E,depth):
			r = Reason()
			if E.type=='AND' or E.type=='OR':   
				r = allReason(E,lambda e: f(e,depth))
			elif E.type=='lazy package':
				r = E.removeParent(self._spec,depth)
			return r
		r = f(self._environ,depth)
		return r
#-- Update
	def updateCheck(self):
		self._update = OR()
		r,p = self._spec.get()
		
		verbo.log('up-check','Checking for update of ['+self._spec.str()+']...')
		if len(self._spec.caches)>0 and tail(self._spec.caches[0],'.snap'):
			verbo.log('up-check','Package ['+self._spec.str()+'] installed from a snapshot - no need to check update...')
		elif r.ok():
			if not self._source==p._source:
				verbo.log('up','Update of ['+self._spec.str()+'] found...')
				self._update           = p._environ
				self._updateSourceCode = p._sourceCode[:]
		else:
			verbo.log('up',"Package ["+self._spec.str()+"] not found...")
		if r.ok(): r = self._environ.updateCheck()
		return r
	def updateRemove (self): 
		self._update = OR()
		return self._environ.updateRemove()
	def updateWaiting(self): return Reason('No update waiting.',self._update == OR())
	def updateSelf(self):
#		verbo.log('up','About to update ['+self._spec.str()+']...')
#		r = ask.re('up','OK to update ['+self._spec.str()+']?')
		r = Reason()
		if r.ok():
			r = Reason("Can't update relative package ["+self.str()+"].",self._neutered)
			if r.ok():
				if not self._update==OR():
					upd = self.status()[1]
					if upd:
						r = self.setup()
						if r.ok(): r = LazyPackage(self._spec).uninstall(0)
					if r.ok():
						r = ask.re('up','OK to update ['+self._spec.str()+']?')
						if r.ok():
							verbo.log('up','Updating ['+self._spec.name+']...')
							self._environ    = copy.deepcopy(self._update)
							self._source     = copy.deepcopy(self._update)
							self._sourceCode = self._updateSourceCode
							self._update = OR()
							if upd: r = self.satisfy()
					else:
						verbo.log('up',"Can't uninstall ["+self._spec.name+"].  Not updated...")
				else:
					r = self._environ.update()
#					if r.ok(): verbo.log('up','Package ['+self._spec.str()+'] successfully updated...')
#					else:      verbo.log('up','Package ['+self._spec.str()+'] update attempt has failed...')
		return r
	def update(self):
		r = Reason("Can't update relative package ["+self.str()+"].",self._neutered)
		if r.ok():
			if self.updateWaiting(): r = self.updateSelf()
			if r.ok(): r = self._environ.update()
		return self.reasonFixup(r,'updated')
#-- setup
	def shellOut(self,csh,sh,py,pl): 
		lines = ['#\n','#-- '+`self`+'\n','#\n']
		for line in lines: csh.write(line); sh.write(line); py.write(line); pl.write(line)
		self._environ.shellOut(csh,sh,py,pl)

_updateCheck   = {}
_updateRemove  = {}
_updateSelf    = {}
_update        = {}

_satisfied     = {}
_satisfiable   = {}
_satisfy       = {}
_restore       = {}
_remove        = {}
_removeMode    = {}
_uninstallSet  = {}
_uninstallUp   = {}
_uninstall     = {}
_uninstallBody = {}
_fetch         = {}

_verify        = {}
_repair        = {}

_setup         = {}
_setupBody     = {}
_shellOut      = {}

_pardb         = {}
_moddb         = {}

class LazyPackage(Package):
	type   = 'lazy package'
	title  = 'Lazy Package'
	action = 'install lazy package'
	
	def __init__(self,spec=Spec()):
		self._spec      = spec
		self._modified  = 0
		self._parent    = Spec()
		self._lazy = 1

	def lazyApplyU(self,f=lambda p: Reason()):
		c = UniversalCache.UniversalCache('home')
		r,p = c.get(self._spec)
		if not r.ok(): r,p = self._spec.get()
		if r.ok():
			self.modifyApply(p)
			if r.ok(): r = f(p)
		else:
			p = Package()
		return r,p
	def lazyApplyV(self,f=lambda p: Reason()):
		c = UniversalCache.UniversalCache('home')
		r,p = c.get(self._spec)
#		if not r.ok(): r,p = self._spec.get()
		if r.ok():
			self.modifyApply(p)
			if r.ok(): r = f(p)
		else:
			r = Reason()
			p = Package()
		return r,p
	def lazyApplyM(self,f=lambda p: Reason()):
		r,p = self.lazyApplyU(f)
		if not p==Package(): 
			c = UniversalCache.UniversalCache('home')
			r2 = c.put(p)
			if r.ok(): r = r2
		return r
	def modifyApply(self,p):
		if not self._parent==Spec():
			if not (self._parent in p._parents): p._parents.append(self._parent)
			if self._modified:
				if not (self._parent in p._modifiers): p._modifiers.append(self._parent)
		_pardb[self._spec._id()] = p._parents  [:]
		_moddb[self._spec._id()] = p._modifiers[:]
	def modifiers(self):
		r,p = self.lazyApplyU()
		return p._modifiers
	def parents(self):
		r,p = self.lazyApplyU()
		return p._parents
	def removeParent(self,spec,depth=0):
		def f(p):
			r = Reason()
			p._parents   = filter(lambda sp: not spec<=sp, p._parents  )
			p._modifiers = filter(lambda sp: not spec<=sp, p._modifiers)
			UniversalCache.UniversalCache('home').put(p)
			if p._parents==[] and p._modifiers==[]: r = p.remove(depth-1)
			return r
		return self.lazyApplyV(f)[0]
#		return self.lazyApplyU(f)[0]
#-- Set
	def equal(self,p): return self._spec==p._spec
	def str(self): return self._spec.str()
	def display(self,indent=0):
		def f(p): p.display(indent); return Reason()
		r,p = self.lazyApplyU(f)
		if not r.ok(): r.display(indent)
	def displayM(self,depth=99999,indent=0):
		def f(p): p.displayM(depth,indent); return Reason()
		r,p = self.lazyApplyU(f)
		if not r.ok(): r.display(indent)
		return Reason()
	def status(self):
		r,p = self.lazyApplyU()
		return p.status()
	def check(self,db,f):
		idd = self._spec._id()
		if not db.has_key(idd): db[idd] = f()
		elif _pardb.has_key(idd) and _moddb.has_key(idd):
			if (not self._parent in _pardb[idd]) or \
			  ((not self._parent in _moddb[idd]) and self._modified): db[idd] = f()
			else: pass
		else:
			db[idd] = f()
		return db[idd]
	def check0(self,db,f):
		idd = self._spec._id()
		if not db.has_key(idd): db[idd] = f()
		return db[idd]
		
#-- Environment
	def satisfiable  (self): return self.check(_satisfiable,lambda: self.lazyApplyM(lambda x: x.satisfiable      ())    )
	def fetch        (self): return self.check(_fetch,      lambda: self.lazyApplyM(lambda x: x.fetch            ())    )
	def satisfied    (self): 
		r = self.check(_satisfied,  lambda: self.lazyApplyU(lambda x: x.satisfied                            ())[0] )
		if r.ok(): self.lastsat  = 1
		else:      self.lastfail = 1
		return r
	def satisfy      (self): 
		r = self.check(_satisfy,    lambda: self.lazyApplyM(lambda x: x.satisfy                              ())    )
		if r.ok(): self.lastsat  = 1
		else:      self.lastfail = 1
		return r
	def setup      (self): return self.check(_setup,      lambda: self.lazyApplyU(lambda x: x.setup              ())[0] )
	def restore    (self): return self.check(_restore,    lambda: self.lazyApplyM(lambda x: x.restore            ())    )

#-- Install
	def uninstallSet (self        ): return self.check (_uninstallSet, lambda: self.lazyApplyM(lambda x: x.uninstallSet      ())    )
	def remove       (self,depth=0): return self.check0(_remove,       lambda: self.lazyApplyU(lambda x: x.remove       (depth))[0] )
	def uninstall    (self,depth=0): return self.check0(_uninstall,    lambda: self.lazyApplyM(lambda x: x.uninstall    (depth))    )
	def uninstallBody(self,depth=0): return self.check0(_uninstallBody,lambda: self.lazyApplyM(lambda x: x.uninstallBody(depth))    )

#-- Verify
	def verify       (self): return self.check (_verify,       lambda: self.lazyApplyU(lambda x: x.verify        ())[0] )
	def repair       (self): return self.check (_repair,       lambda: self.lazyApplyM(lambda x: x.repair        ())    )
	
#-- Update
	def updateCheck  (self): return self.check (_updateCheck,  lambda: self.lazyApplyM(lambda x: x.updateCheck   ())    )
	def updateRemove (self): return self.check (_updateRemove, lambda: self.lazyApplyM(lambda x: x.updateRemove  ())    )
	def updateSelf   (self): return self.check (_updateSelf,   lambda: self.lazyApplyM(lambda x: x.updateSelf    ())    )
	def update       (self): return self.check (_update,       lambda: self.lazyApplyM(lambda x: x.update        ())    )
	def updateWaiting(self): return self.lazyApplyU(lambda x: x.updateWaiting ())[0]

#-- Setup
	def shellOut(self,csh,sh,py,pl): return self.check(_shellOut,lambda: self.lazyApplyU(lambda x: x.shellOut(csh,sh,py,pl))[0])
