#
#	Copyright 2004, Saul Youssef
#
from Base        import *
from Environment import *
import UniversalAccess,UniversalCache,Execution
import time,cPickle

class MirrorCache(Cache.Cache):
	def __init__(self,cache,mirror=''):
		self.UCL         = cache
		self.location    = ''
		self.type        = 'mirror'
		self._access     = UniversalAccess.UniversalAccess(self.UCL)
		self._mirror     = mirror
		self._updateTime = None
		self._init = 0
		self._contents  = {}
		self._contentsD = {}
		
	def str(self): 
		if self._updateTime==None: return self.UCL+' mirrorr '+self._mirror
		else:                      return self.UCL+' mirrors '+self._mirror+', last updated '+time.ctime(self._updateTime)

	def display(self,indent=0):
		r = self.init()
	
	def create(self,cache):
		r = Reason("Directory ["+self.UCL+"] already exists.",os.path.exists(self.UCL))
		if r.ok():
			r = Execution.execute('mkdir '+self.UCL)
			if r.ok():
				try:
					f = open(os.path.join(self.UCL,'mirror'),'w')
					cPickle.dump(cache,f)
					f.close()
					self._mirror = cache[:]
				except (IOError,OSError):
					r = Reason("Can't create mirror cache at ["+self.UCL+"].  Directory creation failed.")
		if r.ok():
			r = self.update()
		return r
		
	def update(self):
		r = Reason("Cache ["+self.UCL+"] is inaccessible.",not os.path.isdir(self.UCL))
		if r.ok(): r = self._access.access()
		if r.ok(): r,pdb = UniversalCache.UniversalCache(self._mirror).contents()
		if r.ok():
			upcount = 0
			for idd,p in pdb.items():
				if self._contents.has_key(idd) or not (self._contents[idd]==pdb[idd]):
					upcount = upcount + 1
					self._contents   [idd] = pdb[idd]
					r,self._contentsD[idd] = self.downloadResolve(pdb[idd])
					if not r.ok(): break
			
			if r.ok() and upcount>0:
				try:
					f = open(os.path.join(self.UCL,'mirror.db'),'w')
					cPickle.dump((self._contents,self._contentsD,),f)
					f.close()
				except (IOError,OSError):
					r = Reason("Error writing to mirror cache ["+self.str()+"].")
		return r

	def init(self):
		r = Reason()
		if not self._init:
			r = self.access()
			if not r.ok() and os.path.exists(os.path.dirname(self.UCL)):
				r = Execution.execute('mkdir '+self.UCL)
				if r.ok(): r,self._contents = self.mirror()
				if r.ok():
					try:
						r,self._contents = self.mirror()
						f = open(os.path.join(self.UCL,'mirror.db'),'w')
						cPickle.dump(self._contents,f)
						f.close()
					except (IOError,OSError):
						r = Reason("Can't create mirror cache at ["+self.UCL+"].")
			else:
				r,self._contents = self._access.getObj('mirror.db')
		return r
	
	def contents(self,used):
		r,ps = self.init(),[]
		if r.ok():
			for idd,p in self._contentsD.items(): ps.append(p)
		return r,ps
		
	def getAll(self,spec,used):
		r,ps = Trust.trust.add(self.UCL),[]
		if r.ok(): r = self.init()
		if r.ok(): self.check(spec,used)
		if r.ok() and len(self._contentsD)==0: r = Reason("Cache ["+self.UCL+"] is empty")
		if r.ok():
			if spec==Package.Spec('*'):
				r,ps = self.contents()
			else:
				for idd,p in self._contentsD.items():
					if spec.satisfiedBy(p):
						p._inCache = self.UCL
						p._spec.caches = spec.caches[:]
						Package.reduceCaches(p._environ,p._spec.caches)
						ps.append(p)
		if len(ps)==0: r = Reason("Can't find ["+spec.str()+"] in ["+self.str()+"].")
		if len(ps)>0 and not switch('l') and not switch('lc'):
			verbo.log('cache','Package ['+ps[0]._spec.str()+'] found in ['+self.str()+"]...")
		return r,ps
