#
#	Copyright, February 2005, Saul Youssef
#
from Base        import *
from Environment import *
#import ShellCommand,Cache,Package,Platform,shelve,cPickle,Trust
import ShellCommand,Cache,Package,Platform,cPickle,Trust
import time

def specStr(spec,status,indent=0):
	installable,installed,update = status
	s = indent*' '
	if         installed: s = s + '[*]'
	else:                 s = s + '[ ]'
	s = s + ' ' + spec.str()
	if update: s = s + '  << UPDATE AVAILABLE >>'
	return s
	
def pathsub(a,b):
	sub = 0
	a2 = a[:]; b2 = b[:]
	if len(a2)>0 and len(b2)>0:
		if not a2[-1]=='/': a2 = a2 + '/'
		if not b2[-1]=='/': b2 = b2 + '/'
		
		if len(b2)>len(a2):
			if b2[:len(a2)]==a2[:len(a2)]: sub = 1
	return sub
	
def fileify2(x):
	return `abs(hash(x))`

class InstallationCache(Cache.Cache):
	def __init__(self,directory='.'):
		self._dbfile = os.path.join(fullpath(directory),pacmanDir,'ii'+version[:3])
		self._spfile = os.path.join(fullpath(directory),pacmanDir,'is'+version[:3])
		self._exfile = os.path.join(fullpath(directory),pacmanDir,'ie'+version[:3])
		self._shfile = os.path.join(fullpath(directory),pacmanDir,'sh'+version[:3])
		self._dafile = os.path.join(fullpath(directory),pacmanDir,'da'+version[:3])
#		self._db       = {}
		self._sp       = {}
		self._ex       = {}
		self._quotient = {}
		self._init = 0
		self._mode = 'r'
		self._location = fullpath(directory)
		if writeable(self._location): self._mode = 'rw'
		else:                         self._mode = 'r'
		self.UCL = self._location
		self.type = 'installation'
		self._date = ''

	def in_get_key(self,key):
		f = open(os.path.join(self._dbfile,fileify2(key)),'r')
		p = cPickle.load(f)
		f.close()
		return p
		
	def in_put_key(self,key,p):
		path = os.path.join(self._dbfile,fileify2(key))
		removeFile(path)
		f = open(path,'w')
		cPickle.dump(p,f)
		f.close()
		
	def in_remove_key(self,key):
		path = os.path.join(self._dbfile,fileify2(key))
		removeFile(path)
	
	def display(self,indent=0):
		r,ps = self.getAll(Package.Spec(),[])
		r.require()
		def le(p,q): return p._spec.name<=q._spec.name
		sort(ps,le)
		if self._date=='':
			print indent*' '+`self`
		else:
			print indent*' '+`self`+' last modified: '+self._date
		for p in ps: p.display(indent+4)

	def qinit(self):
		self._quotient = {}
		for k,spec in self._sp.items(): self.qadd(spec)
	def qadd(self,spec):
		if self._quotient.has_key(spec.name): 
			if not (`spec._id()` in self._quotient[spec.name]):
				self._quotient[spec.name].append(`spec._id()`)
		else:                                 
			self._quotient[spec.name] =     [`spec._id()`]
	def qrem(self,spec):
		r = Reason()
		if self._quotient.has_key(spec.name):
			try:
				self._quotient[spec.name].remove(`spec._id()`)
				if len(self._quotient[spec.name])==0: del self._quotient[spec.name]
			except ValueError:
				r = Reason("Installation has been corrupted.")
		else:
			r = Reason("Installation has been corrupted.")
		return r

	def platform(self):
		r = Reason()
		pf = fullpath(os.path.join(self.UCL,pacmanDir,'platform'))
		r = Reason("Can't read ["+pf+"].",not readAccess(pf))
		if r.ok(): platform = get(pf)
		else:      platform = Platform.Platform()
		return r,platform

	def init(self):
		r = Reason()
		if self._init==0:
			r,platform = self.platform()
			if r.ok(): r = Reason("Cache ["+`self`+"] installed on ["+`platform`+"].",not platform==Platform.Platform())
			if r.ok():
				if os.path.exists(self._dbfile):
					if readAccess(self._dbfile):
						self._mode = 'r'
						if writeAccess(self._dbfile): self._mode = 'rw'
					else:
						r = Reason("No read access to ["+`self`+"].")
				else:
					r = Reason("Installation ["+`self`+"] does not exist.")
			if r.ok():
				try:
					verbo.log('io','Reading ['+`self`+']...')
					if not os.path.exists(self._dbfile) and contains(self._mode,'w'):
						os.system('mkdir '+self._dbfile)
#					self._db = shelve.open(self._dbfile,self._mode)
					s = open(self._spfile,self._mode)
					self._sp = cPickle.load(s)
					s.close
					x = open(self._exfile,self._mode)
					self._ex = cPickle.load(x)
					x.close()
					y = open(self._shfile,self._mode)
					xdb = cPickle.load(y)
					y.close()
					if os.path.exists(self._dafile):
						z = open(self._dafile,'r')
						lines = z.readlines()
						z.close()
						self._date = lines[0][:-1]
					else:
						self._date = time.ctime(time.time())
					ShellCommand.ShellCommand._executed.update(xdb)
					self.qinit()
					self._init = 1
				except (IOError,OSError):
					r = Reason("Can't open ["+self._dbfile+"].")
			if r.ok():
				if not (len(self._sp)==len(self._ex)):
					r = Reason("Installation ["+`self`+"] has been corrupted.")
		return r
	def save(self):
#		r = Reason()
		r = self.writeable()
		if r.ok():
			try:
				verbo.log('io','Saving ['+`self`+']...')
#				self._db.close()
				s = open(self._spfile,'w')
				cPickle.dump(self._sp,s)
				s.close()
				x = open(self._exfile,'w')
				cPickle.dump(self._ex,x)
				x.close()
				y = open(self._shfile,'w')
				cPickle.dump(ShellCommand.ShellCommand._executed,y)
				y.close()
				z = open(self._dafile,'w')
				z.write(time.ctime(time.time())+'\n')
				z.close()
			except (IOError,OSError):
				r = Reason("Error writing to ["+self._spfile+"].")
		return r
	def writeable(self):
		r = self.init()
		if r.ok() and self._mode!='rw': r = Reason("No write access to ["+`self`+"].")
		return r
		
	def extra(self,p):
		r = self.init()
		if r.ok(): t = p.status()
		else:      t = (0,0,0,'.',)
		return t
#-- Cache
	def put(self,p):
		r = self.writeable()
		if r.ok(): r = ask.re('package-add','About to add ['+p.str()+'] to ['+`self`+']. OK?')
		if r.ok():
			if verbo('inst'): print 'Putting ['+p._spec.name+'] in ['+`self`+']...'
			p._inCache = self.UCL
			idd = p._spec._id()
			try:
#				self._db [`idd`] = p
				self.in_put_key(`idd`,p)
				self._sp [`idd`] = p._spec
				self._ex [`idd`] = self.extra(p)
				self.qadd(p._spec)
			except:
				r = Reason('Error writing to Pacman database.')
		return r
	
	def contents(self,used):
		r,ps = self.getAll(Package.Spec(),[])
		for i in range(len(ps)): ps[i]._spec.caches.insert(0,self.UCL)
		return r,ps
		
	def getLocation(self,location):
		r,ps = Trust.trust.add(self.UCL),[]
		if r.ok(): r = self.init()
		
		if r.ok():
			keys = self._ex.keys()
			for key in keys:
				if location==os.path.commonprefix([location,self._ex[key][3]]): 
					p = self.in_get_key(key)
					ps.append(p)
#					ps.append(self._db[key])
		return r,ps

	def getAll(self,spec,used):
		r,ps = Trust.trust.add(self.UCL),[]
		if r.ok(): r = self.init()
		if r.ok(): r,used = self.check(spec,used)
		
		if r.ok():
			if string.strip(spec.name)=='' or string.strip(spec.name)=='*':
#				keys = self._db.keys()
				keys = self._sp.keys()
				for key in keys:
#					p = self._db[key]
					p = self.in_get_key(key)
					if spec.satisfiedBy(p): ps.append(p)
			else:
				if self._quotient.has_key(spec.name):
					for idd in self._quotient[spec.name]:
						if self._sp[idd]<=spec:
#							p = self._db[idd]
							p = self.in_get_key(idd)
							p._inCache = self.UCL
							if spec.satisfiedBy(p): 
								if not pac_anchor==fullpath(self.UCL): 
									p._neutered=1
									p._parents = []
									for i in range(len(p._modifiers)): p._modifiers[i].caches.insert(0,self.UCL)
								if verbo('inst'):
									print 'Getting package ['+spec.str()+'] from ['+self.UCL+']:'
									p.display(4)
								ps.append(p)
#			if   len(self._db.keys())==0: r = Reason("Installation ["+`self`+"] is empty.")
			if   len(self._sp.keys())==0: r = Reason("Installation ["+`self`+"] is empty.")
			elif len(             ps)==0: r = Reason("Can't find ["+spec.str()+"] in ["+`self`+"].")
		if len(ps)>0 and not self.UCL==pac_anchor and not switch('l') and not switch('lc'): 
			if verbo('cache'): print 'Package ['+ps[0]._spec.str()+'] found in ['+`self`+']...'
		return r,ps

	def topSpecs(self):
		topspecs = []
		Trust.trust.add(self.UCL).require()
		self.init().require()
		
		keys = self._sp.keys()
		nkeys = len(keys)
		goList  = verbo('io')
		goMeter = not goList and verbo('meter') and nkeys>200
		if goMeter: m = Meter(nkeys,'Reading database...')

		count = 0
		for key in keys:
			count = count + 1
			p = self.in_get_key(key)
			if   goList : print 'Reading ['+p._spec.str()+']...'
			elif goMeter: m.meter(count)
			if len(p.parents())==0: topspecs.append(p._spec)
			del p
		return topspecs
#
#	def topSpecs(self):
#		topspecs = []
#		spec = Package.Spec()
#		used = []
#		r,ps = self.getAll(spec,used)
#		specs = []
#		if r.ok():
#			for p in ps:
#				if len(p.parents())==0: topspecs.append(p._spec)
#		return topspecs
			
	def refreshParents(self):
		used = []
#		r = Trust.trust.add(self.URL)
#		if r.ok(): 
		r = self.init()
		
		if r.ok():
			keys = self._sp.keys()
			nkeys = len(keys)
			goList  = verbo('io')
			goMeter = not goList and verbo('meter') and nkeys>200
			if goMeter: m = Meter(nkeys,'Reading database...')
			count = 0
			for key in keys:
				count = count + 1
				p = self.in_get_key(key)
				if   goList : print 'Reading ['+p._spec.str()+']...'
				elif goMeter: m.meter(count)
				
				if not p.type=='lazy package':
					pars = []
					for par in p._parents:
						rr,pp = self.get(par)
						if rr.ok(): pars.append(par)
					p._parents = pars[:]
					mods = []
					for mod in p._modifiers:
						rr,pp = self.get(mod)
						if rr.ok(): mods.append(mod)
					p._modifiers = mods[:]
					self.put(p).require()
		return r
#			
#	def refreshParents(self):
#		used = []
#		r,ps = self.getAll(Package.Spec(),used)
#		if r.ok():
#			for p in ps:
#				if not p.type=='lazy package':
#					pars = []
#					for par in p._parents:
#						rr,pp = self.get(par)
#						if rr.ok(): pars.append(par)
#					p._parents = pars[:]
#					mods = []
#					for mod in p._modifiers:
#						rr,pp = self.get(mod)
#						if rr.ok(): mods.append(mod)
#					p._modifiers = mods[:]
#					self.put(p).require()
#		return Reason()
#	
	
	def remove(self,spec):
#		r = self.init()
		r = self.writeable()
		if r.ok():
			for idd in self._sp.keys():
				spec2 = self._sp[idd]
				if spec2<=spec:
					if spec.guard=='':
#						del self._db[idd]
						self.in_remove_key(idd)
						del self._sp[idd]
						del self._ex[idd]
						self.qrem(spec2)
					else:
#						p = self._db[idd]
						p = self.in_get_key(idd)
						if spec.satisfiedBy(p):
#							del self._db[idd]
							self.in_remove_key(idd)
							del self._sp[idd]
							del self._ex[idd]
							self.qrem(spec2)
		return r
