#
#	Copyright Saul Youssef, July, 2003
#
from Environment import *
from Base        import *

class ChownR(Environment):
	type   = 'change ownership recursively'
	title  = 'Change Ownership Recursively'
	action = 'chownR'
	def __init__(self,directory,owner=getusername()):
		self.__owner          = owner
		self.__directory      = directory
		self.__originalOwners = []
		
	def str(self): return self.__directory+'/... to '+self.__owner

	def satisfied(self):
		def visit(arg,dirname,names):
			for name in names:
				path = os.path.join(dirname,name)
				if owner(path)!=self.__owner:
					arg = 0
					break
		arg = 1
		os.path.walk(self.__directory,visit,arg)
		if arg: 
			return Reason()
		else:
			return Reason('Directory ['+self.__directory+'] contains files not owned by ['+self.__owner+'].')
	
	def satisfiable(self):
		def visit(arg,dirname,names):
			if not writeAccess(dirname): arg = 0
			for name in names:
				path = os.path.join(dirname,name)
				if not writeAccess(dirname): 
					arg = 0
					break
		arg = 1
		os.path.walk(self.__directory,visit,arg)
			
		if arg:
			return Reason()
		else:
			return Reason('Directory ['+self.__directory+'] contains files with no write access.')

#-- Action
	def acquire(self):
		reason = Reason()
		gotit,uid,gid = userids(self.__owner)
		
		def visit(arg,dirname,names):
			arg = 1
			for filename in names:
				try:
					originalOwner = owner(os.path.join(dirname,filename))
					os.chown(os.path.join(dirname,filename),uid,gid)
					self.__originalOwners.append((originalOwner,dirname,filename,))
				except (IOError,OSError):
					arg = 0
		if gotit:
			arg = 1
			os.path.walk(self.__path,visit,arg)
			if not arg: reason.reason('Failure chowning files in ['+self.__path+'].')
		else:
			reason.reason("User ["+self.__owner+"] no longer exists.")
		return reason
			
	def retract(self):
		reason = Reason()
		
		while len(self.__originalOwners)>0 and reason.isNull():
			own,dirname,filename = self.__originalOwners[-1]
			gotit,uid,gid = userids(own)
			
			if gotit:
				try:
					os.chown(os.path.join(dirname,filename),uid,gid)
					self.__originalOwners.pop()
				except (IOError,OSError):
					reason.reason("Can't restore ownership of file ["+fullpath(os.path.join(dirname,filename))+"].")
			else:
				reason.reason("User ["+own+"] no longer exists.")
				
		return reason
					
					
