#
#	Copyright Saul Youssef, 2003
#
from Platform   import *
from Registry   import *
from Base       import *
import webbrowser,sys,Execution,time
	
def launchwebdisplayPython(start=fullpath('$PACMAN_LOCATION/htmls/index.html')):
		if not os.path.exists(start): abort("Missing ["+start+"].  Can't display web page.")
		try:
			webbrowser.open(start,new=0)
		except:
			print 'Warning: Failed to launch web browser viewing ['+start+']...'

def launchwebdisplay(file=fullpath('$PACMAN_LOCATION/htmls/index.html')):
	if not os.path.exists(file): 
		if verbo('browser'): print "Missing ["+file+"].  Can't display web page."
		abort("Missing ["+file+"].  Can't display web page.")
	path = file
	
	if browser('mozilla'):
		if qInpath('mozilla'): 
			if verbo('browser'): print 'About to execute ['+'mozilla '+path+' &'+']...'
			os.system('mozilla '+path+' &')
		else:
			print 'mozilla not found.  Trying netscape...'
			if verbo('browser'): print 'About to execute ['+'netscape file:'+path+' &'+']...'
			os.system('netscape file:'+path+' &')
	elif browser('galeon'):
		if qInpath('galeon'): 
			if verbo('browser'): print 'About to execute ['+'galeon '+path+' &'+']...'
			os.system('galeon '+path+' &')
		else:
			print 'galeon not found.  Trying netscape...'
			if verbo('browser'): print 'About to execute ['+'netscape file:'+path+' &'+']...'
			os.system('netscape file:'+path+' &')
	elif browser('netscape'):
		if qInpath('netscape'): 
			if verbo('browser'): print 'About to execute ['+'netscape file:'+path+' &'+']...'
			os.system('netscape file:'+path+' &')
		else:
			print 'netscape not found.  Trying mozilla...'
			if verbo('browser'): print 'About to execute ['+'mozilla file:'+path+' &'+']...'
			os.system('mozilla file:'+path+' &')
	elif browser('lynx'):
		if qInpath('lynx'): 
			if verbo('browser'): print 'About to execute ['+'lynx '+path+']...'
			os.system('lynx '+path)
		else:
			print 'lynx not found.  Trying w3m...'
			if qInpath('w3m'): 
				if verbo('browser'): print 'About to execute ['+'w3m '+path+']...'
				os.system('w3m '+path)
			else: abort("Can't find a browser.")
	elif browser('w3m'):
		if qInpath('w3m'): 
			if verbo('browser'): print 'About to execute ['+'w3m '+path+']...'
			os.system('w3m '+path)
		else:
			print 'w3m not found.  Trying lynx...'
			if verbo('browser'): print 'About to execute ['+'lynx '+path+']...'
			os.system('lynx '+path)
	else:
		if verbo('browser'): print 'About to launch default browser...'
		launchwebdisplayPython(path)
	
def pacmanCommands():
	message = '\
% pacman -<switch1> <arg1> <arg2>... -<switch2> <arg1> <arg2>\n\
Operations on packages:\n\
    -l   <p1> <p2>...      List installed or remote packages, -d for display options.\n\
    -get                   Fetch, install and setup the indicated list of packages.\n\
    -fetch                 Fetch the indicates packages and add them to your installation.\n\
    -install               Install the indicated packages.\n\
    -setup                 Setup all packages in the installation.\n\
    -uninstall             Uninstall the indicated packages recursively.\n\
    -remove                Remove the indicated packages recursively.\n\
    -remove-all            Remove all packages and the installation entirely.\n\
    -verify                Verify the status of the indicated packages.\n\
    -repair                Repair the indicated packages.\n\
    -update-check          Check if the indicated packages have updates.\n\
    -update                Update the indicated packages.\n\
    -update-remove         Remove potential updates.\n\
Operations on caches:\n\
    -lc     <c1> <c2>...   List the contents of caches c1, c2,..., -d for display options.\n\
    -snap   <c1> <c2>...   Make a snapshot of caches c1, c2,....\n\
    -domain <c1> <c2>...   Display the entire domain of a list of caches.\n\
    -extract-sources       Extracts source code files from a list of caches.\n\
    -extract-downloads     Extracts all the downloads from a list of caches.\n\
Optional switches with saved defaults (do "-<switch> help" to see the options):\n\
    -v                     Verbose messages.\n\
    -d                     Display options for -l or -lc.\n\
    -ask                   Ask permission before certain operations.\n\
    -allow                 Allow certain normally prevented operations.\n\
    -dom                   Display options for -domain.\n\
Miscellaneous:\n\
    -help,-h               This message.\n\
    -version               Show version and platform information.\n\
    -platforms             List known and supported platforms.\n\
    -registry              List registry symbolic names.\n\
    -info                  View documentation in a browser.\n\
    -single                Single package option for remove or uninstall.\n\
    -clear-registry	   Remove all entries from the local registry.\n\
    -clear-preferences     Restore original command line defaults.\n\
    -clear-snapshots       Clears loades snapshots to save disk space.\n\
    -ignore-cookies	   Ignore saved answers to questions.\n\
    -last                  Prints the result of the last Pacman operation.\n\
    -browser               Web browser choice.\n\
    -def                   Display current command line defaults.\n\
    -license               Prints the README file.'
	print message

legalswitches = ['help','h','info','version','v','V','quiet','ask','wget','remove-all','removeall',
   'fetch','install','uninstall','remove','snap','verify','pretendPlatform','license','def','history','last',
   'repair','trust-all-caches','ignore-cookies','clear-registry','allow','cache','browser','extract-sources',
   'extract-downloads','single','no-compatibility','clear-snapshots','domain','dom','clear-lock',
   'clear-preferences','no-download-access-check','debug','l','setup','registry','lc','d','get',
   'platforms','update-remove','update-check','update','pretend-platform']

platformCheck()

def saveCommand(r):
	if os.path.isdir(os.path.join(pac_anchor,pacmanDir)) and not switch('l') and not switch('lc'):
		try:
			r.put(os.path.join(pac_anchor,pacmanDir,'logs','lastResult'))
			com = ''
			for x in sys.argv: com = com + ' ' + x
			f = open(os.path.join(pac_anchor,pacmanDir,'logs','commands'),'a')
			f.write(string.strip(com)+'\n')
			f.close()
		except:
			print "Can't write to ["+pac_anchor+"] installation."

def commandCheck():
	if switch('version') or switch('V'):
		print 'Pacman version:  '+version+version_extra
		print 'Python version: ',sys.version
		if switch('verbose') or switch('v'):
			p = Platform(); pl = Platform().platforms(); pl.reverse()
			print 'Platform: ',Platform(),'also satisfies',[x for x in pl if x!=p.str()]
		else:
			print 'Platform: ',Platform().str()
		if switch('version'): sys.exit(0)
	if os.path.exists('README') and os.path.isdir('boot'):
		print '% cd to a new directory to start a Pacman installation.'
		sys.exit(1)
	if os.path.exists('Pacman.db') or os.path.isdir('E'):
		print 'This is a Pacman 2 installation.  You are running Pacman '+version+'.'
		print 'cd to a new directory to start a new installation.'
		sys.exit(1)
	for sw in switches:
		sw2 = string.split(sw,':')[0]
		if not sw2[1:] in legalswitches:
			pacmanCommands()
			print 'Unknown command line switch ['+sw2+'].'
			sys.exit(1)		
	if switch('help') or switch('h') or switch('-help') or (len(switches)==0 and len(params)>0):
		pacmanCommands()
		sys.exit(0)
	if len(switchItems('single'))>0:
		print 'Error in [-single] placement on command line.  Try again...'
		sys.exit(0)
	if switch('license'):
		os.system('cat $PACMAN_LOCATION/README.html')
		sys.exit(0)
	if switch('clear-lock'):
		removeFile(os.path.join(pac_anchor,pacmanDir,'lock'))
		sys.exit(0)
	if switch('last') or switch('history'):
		path = os.path.join(pac_anchor,pacmanDir)
		if os.path.exists(path):
			try:
				t = os.path.getmtime(os.path.join(path,'logs','lastResult'))
				x = get(os.path.join(path,'logs','lastResult'))
				f = open(os.path.join(pac_anchor,pacmanDir,'logs','commands'),'r')
				lines = f.readlines()
				f.close()
				if len(lines)>0 and len(lines[-1])>0:
					print 'Last command ['+string.strip(lines[-1][:-1])+'] finished at ['+time.ctime(t)+'].'
				x.display()
			except:
				print 'New installation.'
		else:
			print 'No installation at ['+pac_anchor+'].'
		sys.exit(0)
	if switch('clear-registry'):
		registry.clear_registry()
	if switch('clear-preferences'):
		Execution.execute('rm -f '+pacmanDir+'/preferences/*')
		sys.exit(0)
	if switch('clear-snapshots'):
		if os.path.isdir(pacmanDir+'/snapshots'):
			Execution.execute('chmod -R a+w '+pacmanDir+'/snapshots/*; rm -r -f '+pacmanDir+'/snapshots/*')
		sys.exit(0)
	if switch('clear-cookies'):
		if os.path.isdir(pacmanDir+'/cookies'):
			Execution.execute('rm -r -f '+os.path.join(pac_anchor,pacmanDir,'cookies/*'))
		sys.exit(0)
	if switch('info'):
		if os.path.exists(pacmanDir+'/htmls/index.html'): launchwebdisplay()
		else: print 'No Pacman installation in the current directory ['+os.getcwd()+'].'
		sys.exit(0)

	csw,par = switchpar('cache')
	if csw:
		try:
			g = open('trusted.caches','a')
			g.write(par+'\n')
			g.close()
			print 'Cache ['+par+'] added to trusted.caches file.'
		except (IOError,OSError):
			abort('Error writing to trusted.caches file.')
		sys.exit(0)
