#
#	Copyright, Saul Youssef, Feb 2004
#
#       S.Y. Aug. 2004 - make removal more robust.
#
from Environment import *
from Execution   import *
import EnvironmentVariable

class Untarzip(Environment):
	type   = 'untar'
	title  = 'Untars'
	action = 'untar'
	
	def __init__(self,tarball,env=''): 
		self._tarball  = tarball
		self._contents = []
		self._allsub   = 0
		self._env   = env
		self._verify   = switch('verify')
		self._check = 1
		
	def env(self):
		if hasattr(self,'_env'): return self._env
		else:                    return ''
		
	def getCheck(self):
		if hasattr(self,'_check'): return self._check
		else:                      return 1

	def names(self):
		if self.unzip(): 
			verbo.log('shell-all','About to [gunzip --stdout '+self._tarball+' | tar -t -f - ]...')
			status,output = commands.getstatusoutput('gunzip --stdout '+self._tarball+' | tar -t -f - ')
			if status!=0: status,output = commands.getstatusoutput('gunzip --stdout '+self._tarball+' | tar --no-same-owner -t -f - ')
		else:
			verbo.log('shell-all','About to [tar --no-same-owner -t -f '+self._tarball+']...')
			status,output = commands.getstatusoutput('tar --no-same-owner -t -f '+self._tarball)
			if status!=0: status,output = commands.getstatusoutput('tar -t -f '+self._tarball)
		if status==0: return Reason(),string.split(output,'\n')
		else:         return Reason('Error reading '+self._tarball+': ['+output+']'),[]
#-- Set
	def equal(self,u): return self._tarball == u._tarball
	def str(self):     
		s = self._tarball
		if not self.env()=='':
			if hasattr(self,'_enviro'):
				if self._enviro.satisfied():
					s = s + ', top directory: '+self._enviro.str()
				else:
					s = s + ', top directory: '+self._enviro.str()
			else:
				s = s + ', top directory to be set to '+self.env()
		return s
	
	def verify(self):
		if hasattr(self,'_verify'): return self._verify
		else:                       return 0

#-- Satisfiable
	def satisfied(self):
		verb = verbo('tar')
		if not self.getCheck():
			reason = Reason('Tarball ['+self._tarball+'] has not been untar/zipped',not self.acquired)
		else:
			reason = Reason()
#			reason = Reason('Tarball ['+fullpath(self._tarball)+'] does not exist.',not os.path.exists(fullpath(self._tarball)))
			if reason.ok():
				if len(self._contents)==0: 
					reason,paths = self.names()
					for p in paths: self._contents.append(fullpath(p))
				
				if reason.ok():
					verify = switch('verify')
					count = 0
					allthere = 1
					firstthere = 0
					if verify and verb: m = Meter(len(self._contents)-1,'Verifying untarred content of ['+os.path.basename(self._tarball)+']...')
					for p in self._contents:
						if verify and verb: m.meter(count)
						if count==0 and os.path.exists(p): firstthere=1
						if not os.path.exists(p): allthere = 0; break
						if not verify and count > 10: break
						count = count + 1
#					if self.acquired and not allthere:
					if not allthere:
						reason = Reason("Some or all untarred files from ["+fullpath(self._tarball)+"] are missing.")
					elif not allthere:
						reason = Reason("["+fullpath(self._tarball)+"] has not been untarred.")
				if reason.ok(): self._tarball = fullpath(self._tarball)
		return reason
	def satisfiable(self): return Reason()

#-- Action
	def unzip(self): return \
		tail(self._tarball,'.tar.gz') or tail(self._tarball,'.tgz'  ) or \
		tail(self._tarball,'.tar.Z' ) or tail(self._tarball,'.tar.z')
	def untar(self): return tail(self._tarball,'.tar')
	
	def acquire(self):
		reason = Reason()
		ver = verbo('tar')

		path = fullpath(self._tarball)
		if os.path.exists(path):
			self._tarball = path
			reason,paths = self.names()
			
			if reason.ok():
				self._contents = []
				for p in paths: self._contents.append(fullpath(p))
			
#-- Check if untarring would overwrite something
				alreadythere = []
#				verbo.log('tar','Checking that untarring ['+os.path.basename(self._tarball)+"] will not overwrite existing files...")
				contents2 = []
				allow2 = allow('tar-overwrite')
				for p in self._contents:
					if os.path.exists(p):
						if not os.path.isdir(p):
							if len(alreadythere)>999999:
								verbo.log('tar','...{more files not listed}...')
								break
							verbo.log('tar','File ['+p+'] to be untarred from ['+self._tarball+'] already exists...')
							ask.re('tar-over','File ['+p+'] to be untarred from ['+self._tarball+'] already exists.  OK to overwrite?').require() 
							if allow2:
								if not verbo('tar'): 'File ['+p+'] to be untarred from ['+self._tarball+'] already exists...'
								contents2.append(p)
							else:
								alreadythere.append(p)
					else:
						contents2.append(p)
				self._contents = contents2[:]
				
				if len(alreadythere)>0:
					verbo.log('*','Error: Untarring ['+self._tarball+'] would overwrite the following existing files:')
					for x in alreadythere: verbo.log('tar','     '+x)
					reason = Reason("Can't untar ["+self._tarball+"] without overwriting existing files.")
						
				if reason.ok():
					if reason.ok():	
						verbo.log('tar','Untarring ['+os.path.basename(path)+']...')
						if   self.unzip(): 
							reason = ask.re('tar','About to unzip/tar ['+os.path.basename(path)+'].  OK?')
							if reason.ok():
								reason =                     execute('gunzip --stdout '+path+' | tar --no-same-owner -xf - ')
#								reason =                     execute('tar -zxf '+path)
								if not reason.ok(): reason = execute('gunzip --stdout '+path+' | tar                 -xf - ')
						elif self.untar():
							reason = ask.re('tar','About to untar ['+os.path.basename(path)+']. OK?')
							if reason.ok():
								reason =                     execute('tar --no-same-owner -xf '+path)
								if not reason.ok():          execute('tar                 -xf '+path)
					
					if reason.ok() and self.verify():
						allthere = 1
						if ver: m = Meter(len(self._contents)-1,'Verifying untarred content of ['+os.path.basename(path)+']...')
						count = 0
						for p in self._contents:
							if ver: m.meter(count)
							count = count + 1
							if not os.path.exists(p) and not os.path.islink(p): 
								print 'Error: Untarred file ['+p+'] is missing.'
								allthere = 0
							
						if len(self._contents)>0:
							firstfile = self._contents[0]; lff = len(firstfile)
							self._allsub = ('/' in firstfile) and forall(self._contents,lambda x: x[:lff]==firstfile)
						else:
							self._allsub = 0
						if not allthere:
							reason = Reason("["+`self`+"] has not been completely untarred.")
		else:
			reason.reason("Tarball ["+path+"] doesn't exist.")
			
		if reason.ok() and not self.env()=='':
			reason,root = self.untarRoot()
			if reason.ok():
				self._enviro = EnvironmentVariable.SetenvTemp(self.env(),fullpath(root))
				reason = self._enviro.satisfy()
		return reason

	def untarRoot(self):
		file = self._tarball
		unzip = tail(file,'.tar.gz') or tail(file,'.tgz') or tail(file,'.tar.Z') or tail(file,'.tar.z')
		untar = tail(file,'.tar')
		
		if unzip:     reason,root = parseTarZ(file)
		elif untar:   reason,root = parseTar (file)
		else:         reason,root = Reason('File ['+file+'] must end with .tar'),''
		
		return reason,root

	def retract(self):
		if not self.env()=='': reason = self._enviro.restore()
		else:                  reason = Reason()
		if reason.ok():	
			reason = AllReason()
			ver = verbo('tar')
			count = 0
			if self._allsub:
				verbo.log('tar','Removing directory ['+os.path.basename(self._contents[0])+'] untarred from ['+self._tarball+']...')
				reason = ask.re('tar','About to remove directory ['+os.path.basename(self._contents[0])+'] untarred from ['+self._tarball+'].  OK?')
				if reason.ok():
					reason = execute('chmod -R a+w "'+self._contents[0]+'"')
					if reason.ok(): reason = execute('rm -r -f "'+self._contents[0]+'"')
			else:
				reason = ask.re('tar','About to remove untarred contents from ['+os.path.basename(self._tarball)+']. OK?')
				if reason.ok():
					reason = AllReason()
					if len(self._contents)<1000:
						verbo.log('tar','Removing untarred contents from ['+os.path.basename(self._tarball)+']...')
					else:
						if ver: m = Meter(len(self._contents)-1,'Removing untarred contents from ['+os.path.basename(self._tarball)+']...')
					for i in range(len(self._contents)-1,-1,-1):
						if len(self._contents)>=1000:
							if ver: m.meter(count)
						count = count + 1
						f = self._contents[i]
						if os.path.isdir(f): 
#							reason.append(execute('chmod -R a+w "'+f+'"'))
#							reason.append(execute('rm -r -f "'+f+'"'))
							execute('chmod -R a+w "'+f+'"')
							execute('rm -r -f "'+f+'"')
						else:                
#							reason.append(execute('rm -f "'   +f+'"'))
							execute('rm -f "'   +f+'"')
		return reason

class UntarzipDeletable(Untarzip):
	type   = 'untar vdt'
	title  = 'Untars vdt'
	action = 'untar vdt'

	def satisfied(self): return Reason('['+`self`+']'+" hasn't been untarred.",not self.acquired)
