#
#	Copyright, Saul Youssef, August 2003
#
from Access     import *
from Execution  import *
from FileGetter import *
import tempfile,urlAccess2

url_directory_cache = {}
		
class URLAccess(Access):
	type = 'url'
	
	def __init__(self,url): 
		self.url = url
		self.location = url
#-- Set
	def __repr__(self): return self.url
	def equal(self,x): return self.url==x.url
	
	def names(self): return self.namesPath()
			
	def namesPath(self,path=''):
		reason = Reason()
		url2 = os.path.join(self.url,path)
		if url_directory_cache.has_key(url2):
			files = url_directory_cache[url2]
		else:
			reason,files = urlAccess2.urlFiles(url2)
			if reason.ok(): 
				url_directory_cache[url2] = files[:]
		return reason,files
			
	def access(self):
		r,files = self.namesPath()
		return r.ok()
	def getFile(self,name2,target=''):
		reason = Reason()
		
		self.url,name = os.path.split(os.path.join(self.url,name2))
		if target=='': target2 = name
		else:          target2 = target
	
		g = InternetFileGetter(self.url,name)
		
#		tmpdir = tempfile.gettempdir()
		tmpdir = fullpath('$PAC_ANCHOR/'+pacmanDir+'/tmp')
		if not os.path.isdir(tmpdir): tmpdir = fullpath('$TMP')
		removeFile(os.path.join(tmpdir,name))
			
		if switch('wget'):
			if verbo('down'):
				status = os.system('cd '+tmpdir+'; wget '+os.path.join(self.url,name))
				reason = Reason('Failure downloading ['+os.path.join(self.url,name)+'].',not status==0)
			else:
				reason = execute('cd '+tmpdir+'; wget '+os.path.join(self.url,name))
		else:
			reason = g.get(tmpdir)
		if reason.ok(): 
			try:
				execute('mv '+os.path.join(tmpdir,name)+' '+target2)
			except (IOError,OSError):
				reason = Reason("Failure writing ["+name+"] to ["+target2+"].")					
		return reason

class URLAccessSource(URLAccess):
	cache_cache = {}
	
	def getFile(self,name2,target=''):
		if target=='': target2 = name2
		else:          target2 = target
		
		url,name = os.path.split(os.path.join(self.url,name2))		
		if os.path.isdir(target2): target2 = os.path.join(target2,name)

		reason = Reason()
		if self.cache_cache.has_key((name,url,)):
			lines = self.cache_cache[(name,url,)]
			try: 
				f = open(target2,'w')
				for line in lines: f.write(line)
				f.close()
			except (OSError,IOError):
				reason = Reason("Can't put ["+name+"] in ["+target2+"].")
		else:
			g = InternetFileGetter(url,name)
			tmpdir = tempfile.gettempdir()
			removeFile(os.path.join(tmpdir,name))
			
			reason = g.get(tmpdir)
			if reason.ok(): 
				try:
					execute('mv '+os.path.join(tmpdir,name)+' '+target2)
				except (IOError,OSError):
					reason = Reason("Can't put ["+name+"] in ["+target2+"].")
					
			if reason.ok() and tail(name,'.pacman'):
				f = open(target2,'r')
				lines = f.readlines()
				f.close()
				self.cache_cache[(name,url,)] = lines
		return reason
	
