#
#	Copyright Saul Youssef, December 2003
#
from FloatAttr import *
from Platform  import *

def timeDiff(host='tick.mit.edu'):
	if Platform().satisfies(Platform('cygwin')): 
		status,output = commands.getstatusoutput('ntpdate -qb '+host)
	else:
		status,output = commands.getstatusoutput('ntpdate -q  '+host)
		
	if status!=0:
		dTime = 0.0
		reason = Reason("[ntpdate] is not in your path.  Can't test system clock.")
	else:
		ol = string.split(output,' ')
		if len(ol)>2:
			dTime = float(ol[-2])
			reason = Reason()
		else:
			dTime = 0.0
			reason = Reason('[ntpdate -q] gives unexpected output.')
	return reason,dTime

class TimeErrorMaximum(FloatAttr):
	type   = 'time error maximum'
	title  = 'Time Error Maximum'
	action = 'time error maximum'

	def str(self): 
		r,t = timeDiff()
		if r.ok():
			return `self.value`+' seconds.  Actual system time is off by ['+`t`+'] seconds.'
		else:
			return `r`

	def satisfied(self):
		reason,dTime = timeDiff()
		if reason.ok():
			s = '%g' % dTime
			if abs(dTime)>abs(self.value): reason = Reason('System clock is off by '+s+' seconds.  This exceeds maximum of '+`self.value`+' seconds.')
		return reason
	def satisfiable(self): return self.satisfied()
	
	def acquire(self): return self.satisfied()
	def retract(self): return self.satisfied()


