#
#	Copyright 2004, Saul Youssef
#
from Base        import *
from Environment import *
import UniversalAccess,Cache,Package,Source,Message,Trust

class SourceCache(Cache.Cache):
	def __init__(self,cache):
		self.UCL     = cache
		self.type    = 'source'
		self._access = UniversalAccess.UniversalAccess(self.UCL,'source')
	def display(self,indent=0):
		used = []
		r,ps = self.getAll(Package.Spec(),used)
		print indent*' '+`self`
		if r.ok():
			def le(p,q): return p._spec.name<=q._spec.name
			sort(ps,le)
			for p in ps: p.display(indent+4)
		else:
			print indent*' '+`r`
			
	def filenames(self,spec):
		packageFilenames = []
		reason,filenames = self._access.namesPath(spec.subdirectory)
		
		if reason.ok():
			for filename in filenames:
				if spec.filenameEqu(filename): packageFilenames.append(os.path.join(spec.subdirectory,filename))
			
			packageFilenames.reverse()
		return reason,packageFilenames
		
	def packageSource(self,spec,path,source):
		try:
			r,environ,name = Source.SourceFile(source,spec.name,self.UCL,os.path.basename(path)).compN()
		except AbortException,message:
			r,environ,name = Reason(message.value),OR(),spec.name
		spec2 = copy.deepcopy(spec)
		spec2.name = name
		spec2.subdirectory,spec2.file = os.path.split(path)
		p = Package.Package(spec2,self.UCL,spec.locate(environ))
		return r,p
	
	def contents(self,used):
		r,ps = self.getAll(Package.Spec(),[])
		for i in range(len(ps)): ps[i]._spec.caches.insert(0,self.UCL)
		return r,ps
		
	def getAll(self,spec,used):
		r,ps = Trust.trust.add(self.UCL),[]
		if r.ok(): r,used = self.check(spec,used)
		
		if r.ok():
			r,filenames = self.filenames(spec)
			if r.ok():
				for filename in filenames:
					verbo.log('src','About to open source file ['+filename+']...')
					r,source = self._access.getLines(filename)
				
					if r.ok():
						r,p = self.packageSource(spec,filename,source)
						if not r.ok(): 
							if verbo('src'):
								verbo.log('src','Source code in ['+filename+'] from cache ['+`self`+'] has a compilation error.')
								verbo.log('src',`r`)
							else:
								print 'Compilation error in ['+filename+'] in cache ['+`self`+']...'
								print r
								print 'syntax error> '+filename+' from cache '+`self`
								for line in source:
									print 'syntax error> '+line[:-1]
							p._environ = AND(Message.Fail(`r`))
							p._spec.name = filename[:-7]
						p._sourceCode = source[:]
						p._inCache     = self.UCL
						p._sourceCache = self.UCL
						verbo.log('src','File ['+filename+'] contains ['+p._spec.name+']...')
						if verbo('src'):
							if spec.satisfiedBy(p): verbo.log('src','Package ['+p._spec.name+'] satisfies ['+spec.str()+']...')
							else:                   verbo.log('src','Package ['+p._spec.name+'] does not satisfy ['+spec.str()+']...')
						if spec==Package.Spec() or (r.ok() and spec.satisfiedBy(p)): ps.append(p)
					else:
						r = Reason("Can't access ["+filename+"] in cache ["+`self`+"].")	
	
			if r.ok() and len(ps)==0: r = Reason("Can't find ["+spec.str()+"] in ["+`self`+"].")
			if len(ps)>0 and not switch('l') and not switch('lc'): 
				verbo.log('pac','Package ['+ps[0]._spec.str()+'] found in ['+`self`+']...')
		return r,ps
