#
#	Saul Youssef, October, 2003
#
from LocalShelfAccess import *
from        SSHAccess import *
import tempfile

class SSHShelfAccess(Access):
	type = 'ssh database access'
	
	def __init__(self,sshpath):
		self.sshpath = sshpath
		self.location,self.filename = os.path.split(sshpath)
		
		self.fileaccess = SSHAccess(self.location)
		self.localfile = tempfile.mktemp()
		
		reason = self.fileaccess.getFile(self.filename,self.localfile)
		self.laccess = LocalShelfAccess(self.localfile)
		
	def __repr__(self): return self.sshpath
	def equal (self,x): return self.sshpath == x.sshpath
	
	def access (self): return self.laccess.access()
	def names  (self): return self.laccess.names ()
	def getFile(self,name,target2=''): return self.laccess.getFile(name,target2)
