#
#	Copyright Saul Youssef, June 2003
#
from Environment import *
import os

def processList():
	lines = os.popen('ps -f').readlines()
	plist = []
	first = 1
	for line in lines:
		x = string.split(line,'/')
		if first!=1: plist.append(x[-1][:-1])
		if first==1: first = 0
	return plist

class RunningProcess(Environment):
	type = 'runningProcess'
	title = 'Running Processes'
	
	def __init__(self,pname): self.__pname = pname
#-- Set
	def equal(self,rp): return self.__pname==rp.__pname
	def str(self):      return self.__pname
	
#-- Compatible
	def compatible(self,g): return Reason()

#-- Satisfiable
	def satisfied(self): 
		if self.__pname in processList():
			return Reason()
		else:
			return Reason('Process ['+self.__pname+'] is not running.')

	def satisfiable(self): return self.satisfied()
	

			
