#
#	Copyright, Saul Youssef, August 2004
#
from Environment import *
import pickle

def registry0():
	reg = {}
	reg['Dartmouth'] = Register('Dartmouth',  'http://grid.dartmouth.edu/pacman/','Dartmouth','Dartmouth College','James E. Dobson','James.E.Dobson@Dartmouth.EDU')
	reg['ATLAS']     = Register(    'ATLAS',  'http://atlas.web.cern.ch/Atlas/GROUPS/SOFTWARE/OO/pacman/cache/',                      'The Atlas Experiment, CERN',  'http://atlas.web.cern.ch/Atlas/GROUPS/SOFTWARE/OO/sit/Distribution/', 'Christian Arnault', 'arnault@lal.in2p3.fr')
	reg['Pacman']    = Register(   'Pacman',  'http://physics.bu.edu/pacman/sample_cache/',                       'Pacman Headquarters, Boston University',  'http://physics.bu.edu/~youssef/pacman/',  'Saul Youssef',                        'youssef@bu.edu')
	reg['Demo']      = Register(     'Demo',  'http://physics.bu.edu/pacman/demo/',                       'Pacman Demos',  'http://physics.bu.edu/~youssef/pacman/',  'Saul Youssef',                        'youssef@bu.edu')
	reg['BU']        = Register(       'BU',  'http://atlas.bu.edu/caches/',                            'Atlas Tier 2, Boston University',  'http://physics.bu.edu/~usatlas/',         'Saul Youssef',       'http://physics.bu.edu/~youssef/')
	reg['BU-ATLAS']  = Register( 'BU-ATLAS',  'http://atlas.bu.edu/caches/',                            'Atlas Tier 2, Boston University',  'http://physics.bu.edu/~usatlas/',         'Saul Youssef',       'http://physics.bu.edu/~youssef/')
	reg['VDT']       = Register(      'VDT',  'http://www.cs.wisc.edu/vdt/vdt_cache/',                  'Virtual Data Toolkit, University of Wisconson',  'http://www.lsc-group.phys.uwm.edu/vdt/',  'Alain Roy',                          'roy@cs.wisc.edu')
	reg['BNL-PAS']   = Register(  'BNL-PAS',  'http://www.usatlas.bnl.gov/computing/software/pacman/PAS-cache/','Atlas Software, Brookhaven National Laboratory',  'http://www.usatlas.bnl.gov/atlas_psc/',   'Wensheng Deng',                        'wdeng@bnl.gov')
	reg['IU']        = Register(       'IU',  'http://iuatlas.physics.indiana.edu/pacman/IUcache/',                                  'Atlas at Indiana University',  'http://www.indiana.edu/',                 'Leigh Grundhoefer',  'leighg@chestnut.ucs.indiana.edu')
	reg['UTA']       = Register(      'UTA',  'http://heppc12.uta.edu/pacman/',                                          'Atlas, University of Texas at Arlington',  'http://heppc12.uta.edu/atlas/',           'Kaushik De',                         'kaushik@uta.edu')
	reg['UCHEP']     = Register(    'UCHEP',  'http://grid.uchicago.edu/caches/',                                               'HEP at the University of Chicago',  'http://grid.uchicago.edu/atlaschimera',   'Yuri Smirnov',              'smirnov@hep.uchicago.edu')
	reg['GCL']       = Register(      'GCL',  'http://grid.uchicago.edu/caches/gcl/',                              'Grid Component Library, University of Chicago',  'http://grid.uchicago.edu/gcl/',           'Yuri Smirnov',              'smirnov@hep.uchicago.edu')
	reg['ISI']       = Register(      'ISI',  'http://www.isi.edu/~olomu/rls/rls-cache/',                         'RLS at the Information Sciences Institute, USC',  'http://www.isi.edu/',                     'Nosa Olomu',                            'nosa@isi.edu')
	reg['iVDGL']     = Register(    'iVDGL',  'http://hep.uchicago.edu/ivdgl/',                                       'International Virtual Data Grid Laboratory',  'http://www.ivdgl.org/',                   'Rob Gardner',                   'rwg@hep.uchicago.edu')
	return reg

class Registry(HtmlOut,IOAble):
	def __init__(self): 
		if os.path.isdir(fullpath('$PAC_ANCHOR/'+pacmanDir+'/registry')):
			self._regfile = fullpath('$PAC_ANCHOR/'+pacmanDir+'/registry/registry')
		else:
			self._regfile = fullpath(pacmanDir+'/registry/registry')
		if os.path.exists(self._regfile) and not os.path.isdir(self._regfile): 
			verbo.log('registry','Using registry from ['+self._regfile+']...')
			try:
				f = open(self._regfile,'r')
				self._registry = pickle.load(f)
				f.close()
			except IOError,OSError:
				abort('Error attempting to read registry from ['+self._regfile+'].')
		else:
			self._registry = registry0()

	def __repr__(self): return `self._registry`
	def __eq__(self,x): return self._registry==x._registry
	
	def clear_registry(self): 
		self._registry = {}
		return self.save()
	
	def saved(self): return os.path.exists(self._regfile)
	
	def equiv(self,name1,name2):
		eq = 0
		n1,n2 = self.trans(name1),self.trans(name2)
		if name1=='*' or name1=='' or name2=='*' or name2=='':
			eq = 1
		elif contains(n1, ':') or contains(n2, ':') or   \
		     contains(n1, '@') or contains(n2, '@') or   \
		     contains(n1,'//') or contains(n2,'//'):
			eq = equivSlash(n1,n2)
		else:
			eq = fullpath(n1)==fullpath(n2)
		return eq
	
	def has0 (self,name): return self._registry.has_key(name)
	def has  (self,name):
		name2 = string.split(name,'/')[0]
		return self.has0(name2)
	def trans0(self,name): 
		if self.has(name): return self._registry[name].url
		else:              return name
		
	def trans(self,name): 
		transName = self.transPath(name)
#		verbo.log('registry',name+' => '+transName)
			
		return transName
		
	def transPath(self,path3):
		path = os.path.expandvars(os.path.expanduser(path3))
		if    ':' in path: 
			path2 = path
			return path2
		elif len(path)>0 and path[0]=='/':
			path2 = path
			return path2
		elif  '/' in path:
			lp = string.split(path,'/')
			count = 0
			path2 = ''
			for x in lp:
				if count==0: path2 = path2 + self.trans0(x)
				else:        path2 = os.path.join(path2,x)
				count = count + 1
			return path2
		else:
			path2 = self.trans0(path)
			return path2

	def regNames(self): return self._registry.keys()
	def getReg (self,name): return self._registry[name]
		
	def add(self,regEntry):
		reason = self.addable(regEntry)
		if reason.ok():
			verbo.log('registry',regEntry.name+' added to the local registry...')
			self._registry[regEntry.name] = regEntry
			reason = self.save()
		return reason
	def hasReg(self,regEntry):
		reason = Reason()
		if self._registry.has_key(regEntry.name):
			reg = self._registry[regEntry.name]
			reason = Reason('Registry does not contain ['+`self`+'].',not reg==regEntry)
		else:
			reason = Reason('Registry does not contain ['+`self`+'].')
		return reason
	def addable(self,regEntry):
		reason = Reason()
		if self._registry.has_key(regEntry.name):
			reg = self._registry[regEntry.name]
			if not reg==regEntry:
				reason = Reason("Registry contains a different entry for ["+regEntry.name+"].  Can't add ["+`regEntry`+"] to registry.")
		return reason
		
	def remove(self,regEntry):
		reason = Reason()
		if self._registry.has_key(regEntry.name):
			reg = self._registry[regEntry.name]
			if reg==regEntry:
				del self._registry[regEntry.name]
				verbo.log('registry',regEntry.name+' removed from the local registry...')
				reason = self.save()
			else:
				reason = Reason("Registry does not contain ["+`regEntry`+"]. Can't remove.")					
		return reason
		
	def save(self,file=''): 
		reason = Reason()
		try:
			if file=='': path = self._regfile
			else:        path = fullpath(file)
			f = open(path,'w')
			pickle.dump(self._registry,f)
			f.close() 
			self._regfile = path		
		except (IOError,OSError):
			reason = Reason("Error attempting to save registry to ["+self._regfile+"].  Registry not updated.")
		return reason
		
	def remove_registry(self):
		removeFile(self._regfile)
		return Reason()
		
	def htmlOut(self,w):
		w.text('<table>'); w.cr()
		w.text('<tr>')
		w.text('<th>Cache Name</th>')
		w.text('<th>Title</th>')
		w.text('<th>Contact Information</th>')
		w.text('</tr>'); w.cr()
	
		keys = self._registry.keys()
		keys.sort()
		for key in keys:
			reg = self._registry[key]
			
			w.text('<tr>'); w.cr()
			w.text('<td>'); reg.   nameHtml(w); w.text('</td>'); w.cr()
			w.text('<td>'); reg.   infoHtml(w); w.text('</td>'); w.cr()
			w.text('<td>'); reg.contactHtml(w); w.text('</td>'); w.cr()
		w.text('</table>'); w.cr()
		
	def display(self,indent=0):
		keys = self._registry.keys()
		keys.sort()
		print '   - Cache -     - Manager -           - Email -                            - Location - '
		print 140*'-'
		for key in keys:
			reg = self._registry[key]
			print '  ',reg.name,max(0,12-len(reg.name))*' ',reg.contactName,max(0,20-len(reg.contactName))*' ',reg.contactEmail,max(0,35-len(reg.contactEmail))*' ',reg.url
		print 140*'-'

class LocalRegistry(Environment):
	type  = 'local registry'
	title = 'Local Registries'
	action = 'save local registry'
	
	def __init__(self): pass
	def str(self): return 'saved to '+pacmanDir+'/registry'
	def equal(self,x): return 1
	
	def satisfiable (self): return Reason()
	def satisfied   (self): return Reason('Local registry has not been saved.',not registry.saved())
	def acquire     (self): return registry.save()
	def retract     (self): return registry.remove_registry()

class Register(Environment):
	type   = 'register'
	title  = 'Registry Entries'
	action = 'register'
	
	def __init__(self,symbolicName,cacheUrl,infoString='',infoUrl='',contactName='',contactEmail=''):
		self.name         = symbolicName
		self.url          = cacheUrl
		self.infoString   = infoString
		self.infoUrl      = infoUrl
		self.contactName  = contactName
		self.contactEmail = contactEmail
	def str(self): return `self.name,self.url,self.infoString,self.infoUrl,self.contactName,self.contactEmail`
	def equal(self,x): return 	self.name        ==x.name                 and \
					self.url         ==x.url                  and \
					self.infoString  ==x.infoString           and \
					self.infoUrl     ==x.infoUrl              and \
					self.contactName ==x.contactName          and \
					self.contactEmail==x.contactEmail
	
	def nameHtml(self,w): w.link(self.name,self.url)
	def infoHtml(self,w):
		if string.strip(self.infoUrl)=='': 
			w.text('<b>'); w.strongText(self.infoString); w.text('</b>')
		else:                              
			w.text('<b>'); w.strongLink(self.infoString,self.infoUrl); w.text('</b>')
	def contactHtml(self,w):
		if string.strip(self.contactEmail)=='': w.text(self.contactName)
		elif '@' in self.contactEmail: w.text('<i><a href="mailto:'+self.contactEmail+'">'+self.contactName+'</a></i>')
		else: w.text('<i>'); w.link(self.contactName,self.contactEmail); w.text('</i>')
		
	def htmlOut(self,w): 
		w.text('registry entry: '); self.nameHtml(w); w.text(' '); self.infoHtml(w); w.text(' '); self.contactHtml(w)

#-- satisfies
	def satisfiable(self): return registry.addable(self)
	def satisfied  (self): return registry.hasReg (self)
	def acquire    (self): return registry.add    (self)    
	def retract    (self): return registry.remove (self)			

registry = Registry()
