#
#	Copyright, August 2003, Saul Youssef
#
from Environment import *
from Execution   import *

class RPM(Environment):
	type   = 'rpm'
	title  = 'RPMs'
	action = 'install rpm'
	
	def __init__(self,rpmfile): self.rpmfile = rpmfile
#-- Set
	def equal(self,r):  return self.rpmfile == r.rpmfile
	def str(self):      return self.rpmfile
	
#-- Compatible
	def compatible(self,r): return Reason()
	
#-- Satisfiable
	def satisfied(self): 
		if fileInPath('rpm').ok():
			if rpm_installed(self.rpmfile): return Reason()
			else: return Reason('RPM ['+self.rpmfile+'] has not been installed.')
		else:
			return Reason('rpm is not available or is not in your $PATH.')
			
	def satisfiable(self):
		reason = Reason()
		if getusername()=='root': 
			if switch('rpmcheck'): reason = execute('rpm --checksig '+self.rpmfile)
		else:
			reason.reason('You must be root to install rpms.')
		return reason		
#-- Action
	def acquire(self):
		reason = self.satisfiable()
		if reason.ok(): 
			if rpm_replace(self.rpmfile):
				reason = execute('rpm -U --force '+self.rpmfile)
		return reason
		
	def retract(self): reason = execute('rpm -e --nodeps '+self.rpmfile)
	
