#
#	Copyright Saul Youssef, November 2004
#
from Base             import *
from Environment      import *
from StringAttr       import *
import PlatformBase,FinitePreOrder

mtrans = {  'linux-redhat-7.0':'RedHat-7.0',
            'linux-redhat-7.1':'RedHat-7.1',
	    'linux-redhat-7.2':'RedHat-7.2',
	    'linux-redhat-7.3':'RedHat-7.3',
	    'linux-redhat-9'  :'RedHat-9',
	    'linux-redhat-8'  :'RedHat-8',
	    'linux-fedora-1'  :'Fedora-1',
	    'linux-fedora-2'  :'Fedora-2',
	    'linux-fedora-3'  :'Fedora-3',
	    'linux-fedora-4'  :'Fedora-4',
	    'linux-rhel-1'    :'RHEL-1',
	    'linux-rhel-2'    :'RHEL-2',
	    'linux-rhel-3'    :'RHEL-3',
	    'linux-rhel-4'    :'RHEL-4',
	    'linux-rhel-5'    :'RHEL-5',
	    'linux-suse-1'    :'SuSE-1',
	    'linux-suse-2'    :'SuSE-2',
	    'linux-suse-3'    :'SuSE-3',
	    'linux-suse-4'    :'SuSE-4',
	    'linux-suse-5'    :'SuSE-5',
	    'linux-suse-6'    :'SuSE-6',
	    'linux-suse-7'    :'SuSE-7',
	    'linux-suse-8'    :'SuSE-8',
	    'linux-suse-9'    :'SuSE-9',
	    'linux-suse-9.1'  :'SuSE-9.1',
	    'linux-suse-9.2'  :'SuSE-9.2',
	    'linux-suse-9.3'  :'SuSE-9.3',
	    'linux-debian-1'  :'Debian-1',
	    'linux-debian-2'  :'Debian-2',
	    'linux-debian-3'  :'Debian-3',
	    'linux-debian-4'  :'Debian-4',
	    'linux-debian-5'  :'Debian-5',
	    'linux-debian-6'  :'Debian-6',
	    'linux-debian-7'  :'Debian-7',
	    'darwin'          :'Darwin',
	    'linux-debian-3.0':'Debian-3.0',
	    'linux-debian-3.1':'Debian-3.1',
	    'linux-debian-3.2':'Debian-3.2',
	    'linux-debian-3.3':'Debian-3.3',
	    'linux-debian-3.4':'Debian-3.4' }

machines = []

#
#-- make all the translated names equivalent to their translation
#
for key,val in mtrans.items():
	machines.append((key,val,))
	machines.append((val,key,))

#
#-- Unix
#
machines.append(('Unix',          '*',))
machines.append(('Sun',        'Unix',))
machines.append(('Aix',        'Unix',))
machines.append(('Cygwin',     'Unix',))
machines.append(('Darwin',     'Unix',))
machines.append(('Irix',       'Unix',))
machines.append(('unix',       'Unix',))
machines.append(('Unix',       'unix',))

#
#-- Linux
#
machines.append(('Linux',      'Unix',))
machines.append(('RedHat',    'Linux',))
machines.append(('linux2',    'Linux',))
machines.append(('SuSE',      'Linux',))
machines.append(('Fedora',    'Linux',))
machines.append(('RHEL',      'Linux',))
machines.append(('Debian',    'Linux',))
machines.append(('linux',     'Linux',))
machines.append(('Linux',     'linux',))

#
#-- Debian
#
machines.append(('Debian','debian',         ))
machines.append(('debian','Debian',         ))
machines.append(('Debian-3.4','Debian-3.3', ))
machines.append(('Debian-3.3','Debian-3.2', ))
machines.append(('Debian-3.2','Debian-3.1', ))
machines.append(('Debian-3.1','Debian-3.0', ))
machines.append(('Debian-3.0','Debian-3',   ))
machines.append(('Debian-3',  'Debian-3.0', ))
machines.append(('Debian-4','Debian-3',     ))
machines.append(('Debian-3','Debian-2',     ))
machines.append(('Debian-2','Debian-1',     ))
machines.append(('Debian-1','Debian',       ))

#
#-- Red Hat Enterprise Linux
#
machines.append((   'RHEL-4',  'RHEL-3',    ))
machines.append((   'RHEL-3',  'RHEL-2',    ))
machines.append((   'RHEL-2',  'RHEL-1',    ))
machines.append((   'RHEL-1',  'RHEL',      ))

#
#-- SuSE linux
#
machines.append((    'SuSE',   'suse',  ))
machines.append((    'suse',   'SuSE',  ))
machines.append((   'SuSE-8',  'SuSE-7',))
machines.append((   'SuSE-7',  'SuSE-6',))
machines.append((   'SuSE-6',  'SuSE-5',))
machines.append((   'SuSE-5',  'SuSE-4',))
machines.append((   'SuSE-4',  'SuSE-3',))
machines.append((   'SuSE-3',  'SuSE-2',))
machines.append((   'SuSE-2',  'SuSE-1',))
machines.append((   'SuSE-1',  'SuSE',  ))

#
#-- Sun
#
machines.append((     'sun',    'Sun',))
machines.append((     'Sun',    'sun',))

#
#-- Irix
#
machines.append((    'irix',   'Irix',))
machines.append((    'Irix',   'irix',))
machines.append((   'Irix7',  'Irix6',))
machines.append((   'Irix6',  'Irix5',))
machines.append((   'Irix5',  'Irix4',))
machines.append((   'Irix4',   'Irix',))

#
#-- Fedora
#
machines.append((  'fedora',  'Fedora',    ))
machines.append((  'Fedora',  'fedora',    ))
machines.append(( 'Fedora-4', 'Fedora-3',  ))
machines.append(( 'Fedora-3', 'Fedora-2',  ))
machines.append(( 'Fedora-2', 'Fedora-1',  ))
machines.append(( 'Fedora-1', 'Fedora',    ))

#
#-- aix
#
machines.append((   'aix-5.7', 'aix-5.6',))
machines.append((   'aix-5.6', 'aix-5.5',))
machines.append((   'aix-5.5', 'aix-5.4',))
machines.append((   'aix-5.4', 'aix-5.3',))
machines.append((   'aix-5.3', 'aix-5.2',))
machines.append((   'aix-5.2', 'aix-5.1',))
machines.append((   'aix-5.1', 'aix-5.0',))
machines.append((   'aix-5.0',    'aix5',))
machines.append((      'aix5', 'aix-5.0',))
machines.append((      'aix5',    'aix4',))
machines.append((      'aix4',    'aix3',))
machines.append((      'aix3',    'aix2',))
machines.append((      'aix2',    'aix', ))
machines.append((       'aix',     'AIX',))
machines.append((       'AIX',     'aix',))

#
#-- cygwin
#
machines.append((  'cygwin', 'Cygwin',))
machines.append((  'Cygwin', 'cygwin',))
machines.append((  'cygwin', 'CygWin',))
machines.append((  'CygWin', 'cygwin',))

#
#-- darwin
#
machines.append((  'darwin', 'Darwin',))
machines.append((  'Darwin', 'darwin',))

#
#-- misc
#
machines.append(('linux-i386',  'Linux',   ))
machines.append(('linux-i686',  'Linux',   ))
machines.append(('Mandrake',    'Linux',   ))
machines.append(('linux2',      'Linux',   ))

#
#-- Red Hat
#
machines.append(('RedHat-9',  'Redhat-9',  ))
machines.append(('Redhat-9',  'RedHat-9',  ))
machines.append(('RedHat-8',  'Redhat-8',  ))
machines.append(('Redhat-8',  'RedHat-8',  ))
machines.append(('RedHat-7',  'Redhat-7',  ))
machines.append(('Redhat-7',  'RedHat-7',  ))
machines.append(('RedHat-6',  'Redhat-6',  ))
machines.append(('Redhat-6',  'RedHat-6',  ))

machines.append(('RedHat-7.0', 'Redhat-7.0'))
machines.append(('Redhat-7.0', 'RedHat-7.0'))
machines.append(('RedHat-7.0', 'redhat-7.0'))
machines.append(('redhat-7.0', 'RedHat-7.0'))

machines.append(('RedHat-7.1', 'Redhat-7.1'))
machines.append(('Redhat-7.1', 'RedHat-7.1'))
machines.append(('RedHat-7.1', 'redhat-7.1'))
machines.append(('redhat-7.1', 'RedHat-7.1'))

machines.append(('RedHat-7.2', 'Redhat-7.2'))
machines.append(('Redhat-7.2', 'RedHat-7.2'))
machines.append(('RedHat-7.2', 'redhat-7.2'))
machines.append(('redhat-7.2', 'RedHat-7.2'))

machines.append(('RedHat-7.3', 'Redhat-7.3'))
machines.append(('Redhat-7.3', 'RedHat-7.3'))
machines.append(('RedHat-7.3', 'redhat-7.3'))
machines.append(('redhat-7.3', 'RedHat-7.3'))

machines.append(('RedHat-6.2', 'Redhat-6.2'))
machines.append(('Redhat-6.2', 'RedHat-6.2'))
machines.append(('RedHat-6.2', 'redhat-6.2'))
machines.append(('redhat-6.2', 'RedHat-6.2'))

machines.append(('RedHat-7.4', 'Redhat-7.4'))
machines.append(('Redhat-7.4', 'RedHat-7.4'))
machines.append(('RedHat-7.4', 'redhat-7.4'))
machines.append(('redhat-7.4', 'RedHat-7.4'))

machines.append(('RedHat-9',  'RedHat-8',  ))
machines.append(('RedHat-8',  'RedHat-7',  ))
machines.append(('RedHat-7',  'RedHat',    ))

machines.append(('RedHat-7.4','RedHat-7.3',))
machines.append(('RedHat-7.3','RedHat-7.2',))
machines.append(('RedHat-7.2','RedHat-7.1',))
machines.append(('RedHat-7.1','RedHat-7.0',))
machines.append(('RedHat-7.0','RedHat-7',  ))
machines.append(('Redhat-7'  ,'RedHat-6',  ))
machines.append(('RedHat-6.2','Redhat-6.1',))
machines.append(('RedHat-6.1','RedHat-6',  ))

machines.append(('redhat',    'RedHat',    ))
machines.append(('RedHat',    'redhat',    ))
machines.append(('RedHat',    'Redhat',    ))
machines.append(('Redhat',    'RedHat',    ))

#
#-- fermi-linux
#
machines.append(( 'linux-fermi-7.4','linux-fermi-7.3',))
machines.append(( 'linux-fermi-7.3','linux-fermi-7.2',))
machines.append(( 'linux-fermi-7.2','linux-fermi-7.1',))
machines.append(( 'linux-fermi-9.0','linux-fermi-9.0',))
machines.append(( 'linux-fermi-7.1','linux-fermi',    ))
machines.append(( 'linux-fermi',    'Linux',          ))
		
supportedPlatforms = ['RedHat','Fedora','Cygwin','RHEL','AIX','SuSE', 'Debian']

Machines = FinitePreOrder.FinitePreOrder(machines)

def platformstring():
	plat = thisPlatform()
	s = plat
	pl = Platform().platforms(); pl.reverse()
	for x in pl: 
		if x!=plat: s = s + ', ' + x
	return s

def thisPlatform():
	pre,plat = switchpar('pretend-platform')
	if not pre:
		plat = findPlatform()[0]
	if mtrans.has_key(plat): plat = mtrans[plat]
	
	got_one = 0
	for x,y in machines: 
		if plat==x or plat==y: got_one = 1; break
	if not got_one: plat = '*'
	return plat

def platformDisplay():
	print '- Equivalent names of platforms that Pacman recognizes:'
	p = Platform()
	classes = p.platformClasses()
	sort(classes,lambda x,y: string.lower(x[0])<=string.lower(y[0]))
	for c in classes: 
		sys.stdout.write('      { ')
		sort(c,lambda x,y: string.lower(x)<=string.lower(y))
		niceListOut(c)
		sys.stdout.write(' }')
		sys.stdout.write('\n')
	for sup in supportedPlatforms:
		l = []
		for plat in Machines.items():
			if Machines.le(plat,sup): l.append(plat)
		print ' '
		sys.stdout.write('- Supported Architecture ['+sup+']:')
		sort(l,lambda x,y: string.lower(x)<=string.lower(y))
		sys.stdout.write(' { ')
		niceListOut(l)
		sys.stdout.write(' }')
		sys.stdout.write('\n')
	print ' '
	sys.stdout.write('- Your platform ['+p.str()+'] satisfies: ')
	l = []
	for plat in Machines.items():
		if Machines.le(p.str(),plat): l.append(plat)
	sort(l,lambda x,y: string.lower(x)<=string.lower(y))
	sys.stdout.write('{ ')
	niceListOut(l)
	sys.stdout.write(' }')
	sys.stdout.write('\n')

class Platform(Environment):
	type   = 'platform'
	title  = 'Platforms'
	action = 'test platform'
	
	def __init__(self,platform=thisPlatform()): 
		self._platform = platform
		
	def str(self): return self._platform
	def equal(self,x): return self._platform==x._platform
	
	def platforms(self): return Machines.items()
	def platformClasses(self):
		c = Clusters(Machines.items())
		cl = c.cluster(lambda p,q: Machines.eq(p,q))
		return cl
		
	def supported(self): 
		return allow('unsupported-platforms') or exists(supportedPlatforms,lambda plat: Machines.le(self._platform,plat))
#-- Set
	def str(self): return self._platform
	def equal(self,p): return Machines.eq(self._platform,p._platform)

#-- Satisfiable
	def satisfiable(self): return self.satisfied()
	def satisfied(self): 
		if Machines.le(self._platform,thisPlatform()): 
			r = Reason()
		else:
			r = self.platformReason()
		if r.ok(): self.lastsat = 1
		return r

	def name(self): return self._platform
	def platformReason(self): return Reason('Your os is ['+thisPlatform()+'] but it must satisfy ['+self.name()+'].')

#-- SatisfyOrder
	def satisfies(self,p):
		if self.type[:8]==p.type[:8]:
			if    p.type=='platform'   : s = Machines.eq(self._platform,p._platform)
			elif  p.type=='platform <=': s = Machines.ge(self._platform,p.value)
			elif  p.type=='platform <' : s = Machines.gt(self._platform,p.value)
			elif  p.type=='platform >=': s = Machines.le(self._platform,p.value)
			elif  p.type=='platform >' : s = Machines.lt(self._platform,p.value)
			else:  abort('Error in Platform.')
		else:
			s = 0
		return s
				
class PlatformLE(StringAttr):
	type   = 'platform <='
	title  = 'Platform <=s'
	action = 'platform <='

	def satisfied(self): 
		r = Reason('Your os is ['+thisPlatform()+'] but it must be <= ['+self.value+'].',not Machines.ge(thisPlatform(),self.value) )
		if r.ok(): lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()
	
class PlatformLT(StringAttr):
	type   = 'platform <'
	title  = 'Platform <s'
	action = 'platform <'
	
	def satisfied(self): 
		r = Reason('Your os is ['+thisPlatform()+'] but it must be < ['+self.value+'].',not Machines.gt(thisPlatform(),self.value) )
		if r.ok(): self.lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()
	
class PlatformGE(StringAttr):
	type   = 'platform >='
	title  = 'Platform >=s'
	action = 'platform >='
	
	def satisfied(self): 
		r =  Reason('Your os is ['+thisPlatform()+'] but it must be >= ['+self.value+'].',not Machines.le(thisPlatform(),self.value))
		if r.ok(): self.lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()
	
class PlatformGT(StringAttr):
	type   = 'platform >'
	title  = 'Platform >s'
	action = 'platform >'

	def satisfied(self): 
		r = Reason('Your os is ['+thisPlatform()+'] but it must be > ['+self.value+'].',not Machines.lt(thisPlatform(),self.value))
		if r.ok(): self.lastsat = 1
		return r
	def satisfiable(self): return self.satisfied()

def platformCheck():
	p = Platform()
	if not p.supported():
		print '-'
		print '- Platform ['+p.str()+'] is not yet supported.'
		print '- Use [% pacman -allow unsupported-platforms] once to override.'
		print '-'
		sys.exit(1)
