#
#	Copyright, October 2003, Saul Youssef
#
from Access import *
import shelve

class LocalShelfAccess(Access):
	type = 'local data base'
	
	def __init__(self,location): self.location = fullpath(location)
	
	def __repr__(self): return self.location
	def equal (self,x): return self.location == x.location
	
	def accessReason(self): 
		reason = Reason()
		if os.path.exists(fullpath(self.location)):
#			try:
				db = shelve.open(fullpath(self.location),'r')
				db.close()
				self.location = fullpath(self.location)
#			except:
#				reason = Reason("Error opening snapshot file ["+self.location+"].")
		else:
			reason = Reason("Data base ["+fullpath(self.location)+"] doesn't exist.")
		return reason
		
	def access(self): return self.accessReason().ok()
		
	def names(self):
		reason = self.accessReason()
		if reason.ok():
			db = shelve.open(self.location,'r')
			filenames = db.keys()
			db.close()
		else:
			filenames = []
		return reason,filenames
		
	def getFile(self,name,target2=''):
		if target2=='': target = name
		else:           target = target2
		
		reason = self.accessReason()
		if reason.ok():
			db = shelve.open(self.location,'r')
			if db.has_key(name):
				try:
					lines = db[name]
					g = open(target,'w')
					g.write(lines)
#					for line in lines: g.write(line)
					g.close()
				except (IOError, OSError):
					reason = Reason("Error getting ["+name+"] from ["+self.location+"].")
			else:
				reason = Reason("No file ["+name+"] in data base ["+self.location+"].")
			db.close()
		return reason
				
		
