#
#	FileGetter, Copyright Saul Youssef, May 2003.
#
import os,shutil,urllib,urlparse
from Base import *

class FileGetter(Set):
	def get(self,target_directory): abort('Missing get in FileGetter class.')
	def getFile(self):              abort('Missing getText in FileGetter class.')
	def getAsFile(self):            abort('Missing getAsFile in FileGetter class.')
	def gettable(self):             abort('Missing gettable in FileGetter.')
	
class LocalFileGetter(FileGetter):
	def __init__(self,basedirectory,file): self.directory,self.filename = basedirectory,file
	def __repr__(self): return 'File Getter: ['+os.path.join(self.directory,self.filename)+']'		
	def __eq__(self,g): return fullpath(self.directory)==fullpath(g.directory) and self.filename==g.filename
		
	def gettable(self):
		r = Reason()
		if not os.access(os.path.join(fullpath(self.directory),self.filename),os.R_OK):
			r.reason("Can't find ["+os.path.join(fullpath(self.directory),self.filename)+"].")
		return r
		
	def getFile(self):
		r = Reason()
		full = os.path.join(fullpath(self.directory),self.filename)
		try:
			f = open(full,'r')
			file = f.readlines()
			f.close()
		except (IOError, OSError):
			r.reason("Can't read ["+full+"].")
			file = []
		return r,file
		
	def getAsFile(self):
		r = Reason()
		full = os.path.join(fullpath(self.directory),self.filename)
		try:              
			f = open(full,'r')
		except (IOError, OSError):   
			r.reason("No read access to ["+full+"].")
			f = None
		return r,f
		
	def get(self,target_directory):
		r = Reason()
		if os.path.isdir(target_directory):
			full = os.path.join(fullpath(self.directory),self.filename)
			if os.path.exists(full):
				try: 
					shutil.copyfile(full,os.path.join(target_directory,self.filename))
				except (IOError, OSError):
					removeFile(os.path.join(target_directory,self.filename))
			else:
				r.reason("Can't copy ["+full+"] to ["+target_directory+"].  File doesn't exist.")
		else:
			r.reason("Can't copy ["+full+"] to ["+target_directory+"]. Directory doesn't exists.")
		return r
			
	def source(self): return self.directory

def er(file,url):
	if file=='':
		return "Can't reach ["+urlparse.urlparse(url)[1]+"] via the internet."
	else:
		return "Can't reach ["+urlparse.urlparse(url)[1]+"] via the internet.  Can't download ["+file+"]."
			
class InternetFileGetter(FileGetter):
	def __init__(self,baseURL,file):
		self.filename = file
		if len(baseURL)>0 and not baseURL[-1]=='/': self.url = urlparse.urljoin(baseURL+'/',file)
		else:                                       self.url = urlparse.urljoin(baseURL,    file)
		
	def __repr__(self): return 'file Getter: ['+self.url+']'
		
	def __eq__(self,g): return self.filename==g.filename and self.url==g.url
	
	def gettable(self):
		r = Reason()
		verbo.log('http','Attempting to open ['+self.url+']...')
		try:
			f = urllib.urlopen(self.url)
			line = f.readline()
			f.close()
		except (IOError, OSError):
			r.reason(er(self.filename,self.url))
		return r

	def getAsFile(self):
		r = Reason()
		verbo.log('http','Attempting to open ['+self.url+']...')
		try:
			f = urllib.urlopen(self.url)
		except (IOError, OSError):
			r.reason(er(self.filename,self.url))
		return r,f
		
	def getFile(self):
		r = Reason()
		try:
			f = urllib.urlopen(self.url)
			file = f.readlines()
			f.close()
		except (IOError, OSError):
			r.reason(er(self.filename,self.url))
			file = []
		if verbo('http'):
			if r.ok(): print 'Successfully read from ['+self.url+']...'
			else:      print 'Error attemting to read from ['+self.url+']...'
		return r,file
		
	def errorHtml(self,fname):
		maxline = 10
		ok = 0
		try:
			f = open(fname,'r')
			for i in range(maxline):
				line = f.readline()
				if line=='': break
				elif contains(line,'not found on this server'): 
					ok = 1; break
			f.close()
		except (IOError,OSError):
			ok = 1
		return ok
		
	def get(self,target_directory):
		r = Reason()
		if os.path.isdir(target_directory):
			urllib.urlcleanup()
			try:
				verbo.log('http','Downloading ['+self.filename+'] from ['+urlparse.urlparse(self.url)[1]+']...')
				
				if tail(self.filename,'.pacman') or tail(self.filename,'.html') or not verbo('down'):
					fname,head = urllib.urlretrieve(self.url,os.path.join(target_directory,self.filename))
				else:
					fname,head = urllib.urlretrieve(self.url,os.path.join(target_directory,self.filename),dlMeter)
					if not switch('q'): flash()
				
				if self.errorHtml(fname):
					removeFile(os.path.join(target_directory,self.filename))
					r.reason('Download of ['+self.filename+'] from ['+self.url+'] has failed.')					
			except (IOError, OSError):
				verbo.log('http',"Error during download of ["+self.filename+"] from ["+urlparse.urlparse(self.url)[1]+"]...")
				removeFile(os.path.join(target_directory,self.filename))
				r.reason("Error during download of ["+self.filename+"] from ["+urlparse.urlparse(self.url)[1]+"].")
			except KeyboardInterrupt:
				verbo.log('http',"Download interrupted by ^C...")
				removeFile(os.path.join(target_directory,self.filename))
				raise KeyboardInterrupt
			verbo.log('http','Successfully read ['+self.filename+'] from ['+urlparse.urlparse(self.url)[1]+']...')
		else: 
			r.reason("Can't download ["+self.filename+"] to ["+target_directory+"] directory doesn't exist.")
		return r

	def source(self): return urlparse.urlparse(self.url)[1]
