#
#	Copyright Saul Youssef, July 2003
#
from Environment     import *
from FileGetter      import *
from Execution       import *
from UniversalAccess import *
import urlparse
import time,os
import Untarzip

class Download(Environment):
	type   = 'download'
	title  = 'Downloads'
	action = 'download'
	
	def __init__(self,url,deletable=0):
		self._url = url
		self._download = '- unset -'
		self._deletable = deletable
#-- Set
	def equal(self,dd): return self._url == dd._url
		
	def str(self):
		if self._download == '- unset -':
			s = os.path.basename(self._url)+' from '+self._url
		else:
			s = os.path.basename(self._url)+' from '+self._url+' => '+self._download
		if self._deletable: s = s + ' (deletable)'
		return s
	def downfile(self): return os.path.basename(self._url)
	def getDeletable(self):
		if hasattr(self,'_deletable'): return self._deletable
		else:                          return 1

#-- Compatible	
	def compatible(self,d): return Reason()
	
#-- Satisfiable 
	def satisfied(self):
		reason = Reason()
		head,tail = os.path.split(self._url)
		if os.path.exists(tail):
			self._download = fullpath(tail)
		elif self._download=='- unset -':
			reason = Reason('['+self._url+'] has not been downloaded.')
		elif not os.path.exists(self._download):
			if self.getDeletable(): reason = Reason()
			else:                   reason = Reason('Download ['+self._download+'] is missing.')
		else:
			reason = Reason()
		return reason

	def satisfiable(self):
		reason = Reason()
		if 0 and not allow('inaccessible-downloads') and not contains(self._url,'$'):
			for head,tail in self.headtails():
				accessor = UniversalAccess(head)
				reason = Reason("["+head+"] is inaccessible.  Can't download ["+tail+"].",not accessor.access())
			
				if reason.ok(): break
		return reason

	def headtails(self):
		head,tail = os.path.split(os.path.expanduser(self._url))
		hts = []
		if   os.environ.has_key('PAC_CACHE_LOCATION'):
			prefix = os.environ['PAC_CACHE_LOCATION']
			if isURL(head): hts.append((                     head,tail,))
			else:           hts.append((os.path.join(prefix,head),tail,))
		else:
			hts.append((head,tail,))
		return hts

	def acquire(self):
		reason = Reason()
		for head,tail in self.headtails():
			try:
				cwd = os.getcwd()
				accessor = UniversalAccess(head)
				if isURL(head): 
					reason = ask.re('down','OK to download ['+tail+'] from ['+urlparse.urlparse(head)[1]+']?')
					verbo.log('down','Downloading ['+tail+'] from ['+urlparse.urlparse(head)[1]+']...')
				else:         
					reason = ask.re('down','OK to download ['+tail+'] from ['+os.path.basename(head)+']?')
					verbo.log('down','Downloading ['+tail+'] from ['+os.path.basename(head)+']...')
				if reason.ok():
					reason = accessor.getFile(tail)
			except OSError:
				reason = Reason("Current directory does not exist.  Can't download.")
			if reason.ok(): 
				self._download = fullpath(tail)
				break
		return reason
		
	def retract(self):
		reason = execute('rm -f '+self._download)
		if reason.ok(): self._download = '- unset -'
		return reason

class DownloadTime(Environment):
	type   = 'timed download'
	title  = 'Timed Download'
	action = 'time download'
	
	def __init__(self,url,maxtime):
		self._download = Download(url)
		self._maxtime = maxtime  # float
		self._time = 0.0
		
	def equal(self,x): return self._download==x._download and self._maxtime==x._maxtime
	def str(self): 
		if self._time==0.0: return ' of '+self._download._url+' in at most '+('%g'%self._maxtime)+' seconds'
		else: return ' of '+self._download._url+' in '+('%g'%self._time)+' seconds, must be <= '+('%g'%self._maxtime)+' seconds'
	
	def satisfiable(self): return Reason()
	def satisfied(self):
		return Reason(`self`+' has not yet been attempted.',not self.acquired)
	def acquire(self):
		t1 = time.time()
		reason = self._download.satisfy()
		t2 = time.time()
		removeFile(self._download.downfile())
		self._time = t2 - t1
		if reason.ok():
			if t2-t1<=self._maxtime: pass
			else:
				reason = Reason(self._download.downfile()+' downloads in '+('%g'%self._time)+' but its not <= '+('%g'%self._maxtime)+' seconds.')
		return reason
	def retract(self):
		self._time = 0.0
		return Reason()

class DownloadUntarzip(Environment):
	type   = 'downloadUntarzip'
	title  = 'Download and Untar/zips'
	action = 'download and untar/zip'
	
	def __init__(self,url,enviro=''):
		self._url = url
		self._enviro = enviro
		self._download = Download(self._url)
		self._untar    = Untarzip.Untarzip(os.path.basename(self._url),self._enviro)
		
	def equal(self,x): return self._url==x._url and self._enviro==x._enviro
	def str(self): 
		if self._untar._env=='':
			return self._download.str()+' and untar/zip'
		else:
			if hasattr(self._untar,'_enviro'):
				return self._download.str()+' untar/zip with top directory ['+self._untar._enviro.str()+']'
			else:
				return self._download.str()+' untar/zip and set ['+self._untar._env+'] to top directory.'
		
	def satisfiable(self): return Reason()
	def satisfied  (self): return self._untar.satisfied()

	def acquire(self):
		reason = self._download.satisfy()
		if reason.ok(): 
			reason = self._untar.satisfy()
			removeFile(os.path.basename(self._url))
		return reason
	def retract(self): return self._untar.restore()
