#
#	Copyright Saul Youssef, July, 2003
#
from Environment import *
from Base        import *

class Chown(Environment):
	type   = 'change ownership'
	title  = 'Change Ownerships'
	action = 'change ownership'
	def __init__(self,path,owner=getusername()):
		self.__owner         = owner
		self.__path          = path
		self.__originalOwner = ''
#-- Set
	def equal(self,ch): return self.__owner == ch.__owner
	def str(self):      return self.__owner

#-- Compatible
	def compatible(self,cd): return Reason()
	
#-- Satisfiable
	def satisfied(self): 
		if self.__owner=='- any -': return Reason()
		reason = Reason('File ['+self.__path+'] does not exist.',not os.path.exists(fullpath(self.__path)))
		if reason.ok():
			reason,own = owner2(self.__path)
			if reason.ok():
				reason = Reason('File ['+self.__path+'] is not owned by ['+self.__owner+'].',not own==self.__owner)
		return reason
			
	def satisfiable(self):  return Reason()

#-- Action
	def acquire(self):
		reason = Reason()
		gotit,uid,gid = userids(self.__owner)
		
		try:
			self.__originalOwner = owner(self.__path)
			os.chown(self.__path,uid,gid)
		except (IOError,OSError):
			self.__originalOwner = ''
			reason.reason("Failed to change ownership of ["+self.__path+"] to ["+self.__owner+"].")
		return reason
		
	def retract(self): 
		reason = Reason()
		gotit,uid,gid = userids(self.__originalOwner)
		
		try:
			os.chown(self.__path,uid,gid)
			self.__originalOwner = ''
		except (IOError,OSError):
			reason.reason("Failed to restore ownership of ["+self.__path+"] to ["+self.__originalOwner+"].")

		return reason		

class OwnedBy(Chown):
	type   = 'test file ownership'
	title  = 'Test File Ownerships'
	action = 'test file ownership'
	
	def acquire(self): return self.satisfied()
	def retract(self): return Reason()
	
	
