#
#	Copyright, 2004, Saul Youssef
#
from Base import *
import Registry

class Cache(Set,HtmlOut):
	def __init__(self): 
		self.UCL = ''
		self.type = ''
#-- Set
	def __repr__(self  ): return self.UCL
	def __eq__  (self,x): return self.UCL==x.UCL
	
#-- Cache
	def check(self,spec,used):
		r = Reason()
		if exists(used,lambda cache: Registry.registry.equiv(cache,self.UCL)):
			r = Reason("Loop in cache dependencies ["+self.UCL+"->"+self.UCL+"].")
		used.append(self.UCL)
		return r,used
	def getAll(self,spec,used): abort('Missing getAll.')
	def getAllL(self,spec,used): return self.getAll(spec,used)
	def get(self,spec):
		used = []
		r,ps = self.getAll(spec,used)
		p = None
		if r.ok():
			if len(ps)>0: p = ps[0]
			else:         r = Reason("Can't find ["+spec.str()+"] in ["+`self`+"].")
		return r,p
	def put(self,package): return Reason("Can't add package ["+`package`+"] to ["+`self`+"].")
	def remove(self,spec): return Reason("Can't delete ["+`spec`+"] from ["+`self`+"].")
	def save(self):        return Reason()
	
class NullCache(Cache):
	def __init__(self): 
		self.UCL  = 'null'
		self.type = 'null'
	def getAll(self,spec,used): return Reason(),[]
	def put(self,package): return Reason()
