#
#	Copyright, Saul Youssef, November 2004
#
from Base        import *
from Environment import *

import StringAttr,UniversalCache,Package

class AlreadyInstalled(StringAttr.StringAttr):
	type   = 'already installed package'
	title  = 'Already Installed Package'
	action = 'check for an already installed package'
	
	def satisfied(self):
		r = Reason()
		home = UniversalCache.UniversalCache('home')
		r,p = home.get(Package.Spec(self.value))
		if r.ok(): r = p.satisfied()
		if not r.ok(): 
			r = Reason('Package ['+self.value+'] must be installed first.')
		return r

	def satisfiable(self): return self.satisfied()
	def acquire    (self): return self.satisfied()
	def retract    (self): return Reason()
