#
#  add new path values to the front of the path instead of the end.  S.Y. May 2002.
#
import sys,os,urllib,py_compile,time
from unix_base     import *
from Platform      import *
from string        import *
from Caches        import *
from cachetruster  import *
from PackageName   import *
from suffix        import *
from SystemEnviros import *

def q_usePackageRoot(p):
	d = dir(p)
	if phas(d,'usePackageRoot'): 
		return p.usePackageRoot
	else:
		return 1

def install_execute(pac,command):
	if not ask_to_execute(command):
		print 'Installation command ['+command+'] returns with an error in package ['+pac+'].'
		print '['+pac+'] not installed.'
		sys.exit()
		
def install_execute2(pac,dir,command):
	if len(dir)==0:
		dir2 = dir
	elif dir[-1]=='/':
		dir2 = dir[:-1]
	else:
		dir2 = dir
	install_execute(pac,'cd '+dir2+'; '+command)
		
def isAlreadyInstalled(aeo):
	ae = 1
	if aeo.has_key('inpath'):
		paths = aeo['inpath']
		for pa in paths:
			if not qInpath(pa): 
				ae = 0
				break
#			if not os.system('which '+pa) == 0:
#				ae = 0
#				break
	if aeo.has_key('exists'):
		exs = aeo['exists']
		for fi in exs:
			if not os.path.exists(fi):
				ae = 0
				break
	if aeo.has_key('enviros'):
		envs = aeo['enviros']
		for ev in envs:
			if not os.environ.has_key(ev):
				ae = 0
				break
				
	if aeo.has_key('scripts'):
		scripts = aeo['scripts']
		for script in scripts:
			if not ask_to_execute(script):
				ae = 0
				break
				
	if aeo.has_key('commands'):
		commands = aeo['commands']
		for command in commands:
			if not ask_to_execute(command):
				ae = 0
				break
				
	if aeo.has_key('rpms'):
		rpms = aeo['rpms']
		for rpm in rpms:
			if not rpm_installed(rpm):
				ae = 0
				break
				
	if not( aeo.has_key('inpath')  or \
	        aeo.has_key('exists')  or \
		aeo.has_key('enviros') or \
		aeo.has_key('scripts') or \
		aeo.has_key('commands') or \
		aeo.has_key('rpms')   ): ae = 0
	if switch('no-native'):
		return 0
	else:
		return ae
		
def isAlreadyInstalled2(aeo):
	ae = 1
	if len(aeo)>0:
		for pa in aeo[0]:
			if python2():
				t1,t2,t3 = os.popen3('which '+pa)
				if not t3.readline()=='': 
					ae = 0
					break
			else:
				if not os.system('which '+pa) == 0:
					ae = 0
					break
				
	if len(aeo)>1:
		for fi in aeo[1]:
			if not os.path.exists(fi):
				ae = 0
				break
				
	if len(aeo)>2:
		for ev in aeo[2]:
			if not os.environ.has_key(ev):
				ae = 0
				break
				
	allempty = 1
	for l in aeo:
		if len(l)>0:
			allempty = 0
			break
		
	if allempty or switch('no-native'): return 0
	else:        return ae
	
def nullPackage():
#	p = Package('','','','','','',{},[],  [],[],[],[],[],[],[],[],'',[],1,[])
	p = Package('','','','','','',{},[],  [],[],[],[],[],[],[],[],'',[],1,1,[],[],{})
	return p

class Package:
	'Represents a fetchable, installable, removable package.'
	def __init__(self,name,description,url,doc,cache,source,systems,depends,\
	             exists,inpath,bins,paths,enviros,daemons,inst,setup,demo,\
		     already,suffix,usePackageRoot,uninstall,reqs,sys_setenv,pubEnviros,download):
		self.name           = name
		self.description    = description
		self.url            = url
		self.doc            = doc
		self.cache          = cache
		self.source         = source
		self.systems        = systems
		self.depends        = depends
		self.exists         = exists 
		self.inpath         = inpath
		self.bins           = bins
		self.paths          = paths
		self.enviros        = enviros
		self.daemons        = daemons
		self.fetchtime      = time.time()
		self.fetched        = 0
		self.installed      = 0
		self.install_extra  = inst
		self.uninstall_coms = uninstall
		self.setup          = setup
		self.demo           = demo
		self.alreadyInstalled = already
		self.suffixHandling = suffix
		self.usePackageRoot = usePackageRoot
		self.download       = download
		self.location       = os.getcwd()
		self.requires       = reqs
		self.systemSetenv   = sys_setenv
			
		self.pubEnviros = []
		for en in pubEnviros:
			if os.environ.has_key(en): self.pubEnviros.append([en,os.environ[en]])
			else:                      self.pubEnviros.append([en,''])

		self.root           = ''
#		print self.name,self.uninstall_coms
#		if yesno('go on'): pass
		
	def reqs(self):
		d = dir(self)
		if phas(d,'requires'): return self.requires
		else:                  return []
		
	def systemEnv(self):
		d = dir(self)
		if phas(d,'systemSetenv'): return self.systemSetenv
		else:                      return ''
	
	def getPubEnviros(self):
		d = dir(self)
		if phas(d,'pubEnviros'): return self.pubEnviros
		else:                    return []
	
	def req_enforce(self,pdb):
		requirements = self.reqs()
		nmissing = 0
		for r in requirements:
			if pdb.has_key(pn(r).name):
				print r,pn(r).name,pn(r).cache,pdb[pn(r).name].cache
				if pn(r).cache==pdb[pn(r).name].cache:
					if verbose: print 'Required package ['+r+'] is installed.  Continuing...'
				else:
					nmissing = nmissing + 1
					print 'You must install ['+r+'] first before fetching ['+self.name+'].'
			else:
				nmissing = nmissing + 1
				print 'You must install ['+r+'] first before fetching ['+self.name+'].'
			
			if nmissing>0:
				sys.exit()
	
	def fileRootUrl(self):
		if not ( self.download=={} ):
			if self.platform().has_key(findPlatform()):
				file = self.platform()[findPlatform()]
			elif   self.download.has_key('*'):
				file = self.download['*']
			else:
				print "Package ["+self.name+"] is not available for platform ["+findPlatform()[0]+"]."
				sys.exit()
			root = ''
#			root = downloadroot(file)
			
			if not (self.systems=={}):
				print "Attempt to use both [download] and [systems] in package ["+self.name+"]."
				sys.exit()
		elif not ( self.systems=={} ):
			if   self.platform().has_key(findPlatform()):
				file = self.platform()[findPlatform()][0]
				root = self.platform()[findPlatform()][1]
			elif self.systems.has_key('*'):
				file = self.systems['*'][0]
				root = self.systems['*'][1]
			else:
				print "Package ["+self.name+"] is not available for platform ["+findPlatform()[0]+"]."
				sys.exit()
		else:
			file = ''
			root = ''
			
		if self.source[0:5]=='http:' or self.source[0:4]=='ftp:' or self.source[0:5]=='file:':
#			url = self.source
			url = fncat(self.source,file)
		elif self.systems=={} and self.download=={}:
			url = ''
		else:
			url = fncat(fncat(self.cache,self.source),file)
#			url = self.cache

		return (file,root,url)
		
	def downloadEquiv(self,p):
		file0,root0,url0 = self.fileRootUrl()
		file1,root1,url1 = p.fileRootUrl()
		return (file0==file1)
		
	def filename(self):
		if not ( self.download=={} ):
			if self.platform().has_key(findPlatform()):
				file = self.platform()[findPlatform()]
			elif   self.download.has_key('*'):
				file = self.download['*']
			else:
				print "Package ["+self.name+"] is not available for platform ["+findPlatform()[0]+"]."
				sys.exit()
			
			if not (self.systems=={}):
				print "Attempt to use both [download] and [systems] in package ["+self.name+"]."
				sys.exit()
		elif not ( self.systems=={} ):
			if   self.platform().has_key(findPlatform()):
				file = self.platform()[findPlatform()][0]
			elif self.systems.has_key('*'):
				file = self.systems['*'][0]
			else:
				print "Package ["+self.name+"] is not available for platform ["+findPlatform()[0]+"]."
				sys.exit()
		else:
			file = ''

		return file

	def equiv(self,p):
		if self.name             == p.name           and \
		   self.description      == p.description    and \
		   self.url              == p.url            and \
		   self.doc              == p.doc            and \
		   self.cache            == p.cache          and \
		   self.source           == p.source         and \
		   self.systems          == p.systems        and \
		   self.depends          == p.depends        and \
		   self.exists           == p.exists         and \
		   self.inpath           == p.inpath         and \
		   self.bins             == p.bins           and \
		   self.paths            == p.paths          and \
		   self.enviros          == p.enviros        and \
		   self.daemons          == p.daemons        and \
		   self.install_extra    == p.install_extra  and \
		   self.setup            == p.setup          and \
		   self.demo             == p.demo           and \
		   self.suffixHandling   == p.suffixHandling and \
		   self.systemEnv()      == p.systemEnv()    and \
		   self.downloadEquiv(p) and \
		   self.alreadyInstalled == p.alreadyInstalled:
			return 1
		else:
			return 0
			
	def platform(self):
		if not (self.download=={}): plat = Platforms(self.download)
		else:                       plat = Platforms(self.systems)
		return plat
		
	def display(self):
		def daemon_status_print(daemon):
			psf = os.popen('ps -edalf').readlines()
			l = len(daemon)
			for line in psf:
				if daemon == line[len(line)-1-l:len(line)-1]: return 'RUNNING'
			return 'NOT RUNNING'
			
		print '                          name:  ',self.name
		print '                   description:  ',self.description
		print '                           URL:  ',self.url
		print '                    local docs:  ',self.doc
		print '                         cache:  ',self.cache
		print '                        source:  ',self.source
		print '                  time fetched:  ',time.ctime(self.fetchtime)
		print '                       systems:  ',self.systems
		print '                      download:  ',self.download
		print '                    depends on:  ',self.depends
		print '     files required to install:  ',self.exists
		print '     binaries in path required:  ',self.inpath
		print '                      binaries:  ',self.bins
		for daemon in self.daemons:
			print ( '                        daemon:  '+daemon+': '+daemon_status_print(daemon) )
		print '                         paths:  ',self.paths
		print '         environment variables:  ',self.enviros
		print '                      fetched?:  ',self.fetched
		print '                    installed?:  ',self.installed
		print '        extra install commands:  ',self.install_extra
		print '            uninstall commands:  ',self.uninstall_coms
		print '                  demo command:  ',self.demo
		print ' natively installed conditions:  ',self.alreadyInstalled
		print '              suffix handling?:  ',self.suffixHandling
		print '   use package root directory?:  ',q_usePackageRoot(self)
		print '               set system Env?:  ',self.systemEnv()
		print '                      location:  ',self.location
		print '  public environment variables:  ',`self.getPubEnviros()`
		
	def fetch(self,pdb,pg):
		if self.fetched:
			pass
		elif isAlreadyInstalled(self.alreadyInstalled):
			self.fetched = 1
			self.fetchtime = time.time()
		elif not self.location==os.getcwd():
			for pac in self.depends:
				p = pg.get(pac)
				p.fetch(pdb,pg)
			self.fetched = 1
			self.fetchtime = time.time()
		else:
			self.req_enforce(pdb)
			
			for pac in self.depends:
				p = pg.get(pac)
				p.fetch(pdb,pg)
				
			file,root,url = self.fileRootUrl()
#			if not self.download=={}: root = downloadroot(file)
				
			if not file=='':
#				print 'Fetching ['+url+']...'
				print 'Fetching ['+self.name+'] from ['+self.cache+']...'
				try:
					urllib.urlretrieve(url,file)
				except IOError:
					print 'Error fetching ['+url+'].'
					print 'Package ['+self.name+'] not fetched.'
					sys.exit()
				
			if not self.download=={}: root = downloadroot(file)
			self.fetched = 1
			self.fetchtime = time.time()
			if self.download=={}:
				self.root = root
			elif file == '':
				self.root = ''
			else:
				self.root = root

		pdb[self.name] = self
		return pdb

	def install(self,pdb):
		if not self.fetched:
			print 'You much -fetch ['+self.name+'] before installing it.'
			sys.exit()
		elif self.installed: 
#			pass
			if verbose: print 'Package ['+self.name+'] is already installed...'
			self.set_enviros(self.root)
			self.add_to_paths(self.root)
		elif isAlreadyInstalled(self.alreadyInstalled):
			print 'Accepting non-Pacman package ['+self.name+'] as natively installed...'
			self.installed = 2
		elif not self.location==os.getcwd():
			self.installed = 1
			for pac in self.depends:
				if pdb.has_key(pn(pac).name):pdb = pdb[pn(pac).name].install(pdb)
				else:
					print "Can't install ["+pn(pac).name+"].  It hasn't been fetched."
					sys.exit()
			
			self.set_enviros2 (self.location,self.root)
			self.add_to_paths2(self.location,self.root)
					
#		elif self.source=='' or self.platform().has_key(findPlatform()) or self.systems.has_key('*'):
#		elif self.systems=={} or self.platform().has_key(findPlatform()) or self.systems.has_key('*'):
		else:
			for pac in self.depends:
				if pdb.has_key(pn(pac).name): pdb = pdb[pn(pac).name].install(pdb)
				else: 
					print "Can't install ["+pn(pac).name+"].  It hasn't been fetched."
					sys.exit()
					
			if not self.systemEnv()=='':
				print 'Setting ['+self.systemEnv()+'] to point to this installation for all users...'
				sysEnv = SystemEnviros()
				sysEnv.insert(self.systemEnv())
				sysEnv.place()

			file,root,url = self.fileRootUrl()
			if not self.download=={}: root = downloadroot(file)

			for fi in self.exists:
				if not os.path.exists(os.path.expandvars(os.path.expanduser(fi))):
					print 'File ['+fi+'] is missing.  It is required to install ['+self.name+'].'
					sys.exit()
				elif verbose:
					print 'Checking that file ['+fi+'] exists.  OK...'
				
			for pa in self.inpath:
				if python2():
					t1,t2,t3 = os.popen3('which '+pa)
					if not t3.readline()=='':
						print '['+pa+'] must be in $PATH to install ['+self.name+'].'
						sys.exit()
					elif verbose:
						print 'Checking that ['+pa+'] is in $PATH.  OK...'
				else:
					if not os.system('which '+pa) == 0:
						print '['+pa+'] must be in $PATH to install ['+self.name+'].'
						sys.exit()
					elif verbose:
						print 'Checking that ['+pa+'] is in $PATH.  OK...'
					
			if      len(self.install_extra.keys()) == 0: commands = []
			elif self.install_extra.has_key(username()): commands = self.install_extra[username()]
			elif self.install_extra.has_key('*'):        commands = self.install_extra['*']
			else:
				print 'Your username must be on this list to install ['+self.name+']:'
				for login in self.install_extra.keys(): print '      ',login
				sys.exit()

#			if not self.source=='':
			if not (self.systems=={} and self.download=={}):
				if self.suffixHandling:
					if tail(file,'.tar.gz') or tail(file,'.tgz') or tail(file,'.tar.Z'):
#						if verbose: install_execute(self.name,'tar zxvPf '+file)
#						else:       install_execute(self.name,'tar zxPf '+file)
						if verbose: install_execute(self.name,'gunzip --stdout '+file+' | tar xvPf - ')
						else:       install_execute(self.name,'gunzip --stdout '+file+' | tar xPf  - ')
						if not string.strip(root)=='' and not string.strip(root)=='.': 
							self.uninstall_coms.insert(0,'rm -r -f '+root)
					elif tail(file,'.tar'):
						if verbose: install_execute(self.name,'tar xvPf '+file)
						else:       install_execute(self.name,'tar xPf '+file)
						if not string.strip(root)=='' and not string.strip(root)=='.': 
							self.uninstall_coms.insert(0,'rm -r -f '+root)
					elif tail(file,'.rpm'):
						if (switch('rpmcheck')): install_execute(self.name,'rpm --checksig '+file)
						if rpm_replace(self.name):
							install_execute(self.name,'rpm -U --force '+file)
#							install_execute(self.name,'rm -f '+file)
							self.uninstall_coms.insert(0,'rpm -e --nodeps '+self.name)
						else:
							install_execute(self.name,'rpm -U '+file)
#							install_execute(self.name,'rm -f '+file)
							self.uninstall_coms.insert(0,'rpm -e --nodeps '+self.name)
					elif string.strip(file)=='':
						pass
					else:
						print 'Downloaded file ['+file+'] must be .tar.gz, .tgz, .tar.Z, .tar or .rpm.'
						sys.exit()
			
			self.set_enviros(root)
			self.add_to_paths(root)
			if q_usePackageRoot(self) and not (self.systems=={} and self.download=={}) and self.suffixHandling:
#				for command in commands: install_execute(self.name,'cd '+root+'; '+command)
				for command in commands: 
					install_execute2(self.name,root,os.path.expandvars(os.path.expanduser(shx(command))))
			else:
				for command in commands: 
					install_execute(self.name,os.path.expandvars(os.path.expanduser(shx(command))))
			self.installed = 1
			
			if not switch('savedownload') and not file=='': install_execute(self.name,'rm -f '+file)
			
			print 'Package ['+self.name+'] has been installed.'

		pdb[self.name] = self
		return pdb

	def uninstall(self,pdb):
		if not self.installed:
			pass
		else:
			if switch('r') or switch('recursive'):
				for pac in self.depends:
					if pdb.has_key(pn(pac).name): pdb[pn(pac).name].uninstall(pdb)
				
			if not self.systemEnv()=='':
				sysEnv = SystemEnviros()
				sysEnv.remove(self.systemEnv())
				sysEnv.place()
				
			if self.location==os.getcwd(): 
				ucoms = self.uninstall_coms
				ucoms.reverse()
				for com in               ucoms: 
					ask_to_execute(os.path.expandvars(os.path.expanduser(com)))
			self.installed = 0
			self.uninstall_coms = []
		pdb[self.name] = self
		return pdb
		
	def remove(self,pdb):
		if switch('r') or switch('recursive'):
			for pac in self.depends:
				if pdb.has_key(pn(pac).name): pdb = pdb[pn(pac).name].remove(pdb)
			
		if self.installed and os.getcwd()==self.location: self.uninstall(pdb)
		
		file,root,url = self.fileRootUrl()
		if os.path.exists(file): ask_to_execute('rm -f '+file)
			
		del pdb[self.name]
		return pdb
		
	def removeSelf(self,pdb):
		if self.installed and os.getcwd()==self.location: self.uninstall(pdb)
		
		file,root,url = self.fileRootUrl()
		if os.path.exists(file): ask_to_execute('rm -f '+file)
			
		del pdb[self.name]
		return pdb
			
	def set_enviros(self,root):
		self.set_enviros2(os.getcwd(),root)
			
	def set_enviros2(self,loc,root):
#		file,root,url = self.fileRootUrl()
		
		for env in self.enviros:
			if len(env[1])>2:
				if env[1][0:1]=='|' and env[1][-1]=='|':
					val = env[1][1:-1]
				elif q_usePackageRoot(self):
					val = fncat(fncat(loc,root),env[1])
				else:
					val = env[1]
			else:
				val = fncat(fncat(loc,root),env[1])
			
#			os.environ[env[0]] = fncat(fncat(loc,root),env[1])
			os.environ[env[0]] = val
			if verbose: print 'Setting environment variable ['+env[0]+'] to ['+os.environ[env[0]]+'].'
			
	def add_to_paths(self,root):
		self.add_to_paths2(os.getcwd(),root)

	def add_to_paths2(self,loc,root):
		for path in self.paths:
#..................................fix found by Scott Koranda, fix suggested by Alain Roy.....
			if len(path[1]) > 2 and path[1][:1]=='|' and path[1][-1]=='|':
				pathval = path[1][1:-1]
			elif q_usePackageRoot(self):
				pathval = fncat(fncat(loc,root),path[1])
			else:
				pathval = path[1]
#..................................................................
#				
#			if q_usePackageRoot(self):
#				pathval = fncat(fncat(loc,root),path[1])
#			else:
#				pathval = path[1]
#			
			if not os.environ.has_key(path[0]):
				os.environ[path[0]] = pathval
				if verbose: print 'Setting ['+path[0]+'] to ['+pathval+'].'
			elif not substr(pathval,os.environ[path[0]]):
#				os.environ[path[0]] = os.environ[path[0]]+':'+pathval
				os.environ[path[0]] = pathval+':'+os.environ[path[0]]
				if verbose: print 'Adding ['+pathval+'] to path variable ['+path[0]+'].'
