
import string

class Registry:
	'Cache name registry'
	def __init__(self):
		self.db = { \
				'VDT':    ['http://www.lsc-group.phys.uwm.edu/vdt/vdt_cache/','VDT','University of Wisconson','Alain Roy','roy@cs.wisc.edu'], \
				'iVDGL':  ['http://hep.uchicago.edu/ivdgl/','WorldGrid','iVDGL','Rob Gardner','rwg@hep.uchicago.edu'],\
				'DataTAG':['http://grid.infn.it/packaging/','European Data Grid','DataTAG','Luca Vaccarossa','Luca.Vaccarossa@.mi.infn.it'],\
				'Pacman': ['http://physics.bu.edu/~youssef/pacman/sample_cache/','Pacman','Boston University','Saul Youssef','youssef@bu.edu'], \
				'BU':     ['http://atlasgrid.bu.edu/atlasgrid/atlas/atlas_cache/','Atlas Accessories','Boston University','Saul Youssef','youssef@bu.edu'],\
				'BNL-ACF':['http://www.usatlas.bnl.gov/computing/software/pacman/ACF-cache/','Atlas Grid','Brookhaven National Laboratory', \
								'Jason Smith','smithj4@bnl.gov'],\
				'BNL-PAS':['http://www.usatlas.bnl.gov/computing/software/pacman/PAS-cache/','Data Management','Brookhaven National Laboratory', \
								'Wensheng Deng','wdeng@bnl.gov'],\
				'IU':     ['http://iuatlas.physics.indiana.edu/pacman/IUcache/','Grid Portal','Indiana University','Shava Smallen', \
								'ssmallen@cs.indiana.edu'], \
                		'UM':     ['http://atgrid.physics.lsa.umich.edu/PacMan/UMCache/','Iperf','University of Michigan','Shawn McKee',\
                                                                'smckee@umich.edu'],\
				'UTA':    ['http://heppc12.uta.edu/pacman/','Atlfast','UT Arlington','Kaushik De','kaushik@uta.edu'], \
				'OU':     ['http://www-hep.nhn.ou.edu/atlas/grid/pacman-cache/','Grat','Oklahoma University','Horst Severini','hs@nhn.ou.edu'] \
				}
				
	def has(self,name):
		return self.db.has_key(name)
		
	def url(self,name):
		if self.has(name):
			return self.db[name][0]
		else:
			return name

	def table(self):
		print ''
		print '- Pacman Cache Registry -'
		print ''
		print string.rjust('Name',15),string.rjust('Content',25),string.rjust('Contact Person',25),\
		            string.center('URL',63)
		print string.rjust('-'*15,15),string.rjust('-'*25,25),string.rjust('-'*25,25),\
		            string.rjust('-'*63,63)
		for key in self.db.keys():
			r = self.db[key]
			print string.rjust(key,15),string.rjust(r[1],25),string.rjust(r[4],25),string.rjust(r[0],63)
#			print '%2d %3d %4d' % (key,r[1],r[2])
#			print key,self.db[key]
		print string.rjust('-'*15,15),string.rjust('-'*25,25),string.rjust('-'*25,25),\
		            string.rjust('-'*63,63)
		print 'You can use the above caches referring to the symbolic name in the first column as in "Pacman:nedit".'
		print ''		

creg = Registry()
