import sys
import re
import types

# findPlatform will return a list of platforms. They all describe the
# platform we are using, but the list is ordered from most-specific
# to least specific. For example, on Red Hat Linux 7.2, we get:
#     ['linux-redhat-7.2', 'linux-redhat', 'linux-i386', 'unix']
# For systems that we know less about, we return a shorter list, like:
#     ['sunos5', 'unix']
# In the future, we may expand the list to include kernel/libc versions
# in the list. The list will probably be ordered like:
#  [redhat-version, kernel-version, linux, unix]
def findPlatform():
	base_platform = sys.platform;
	if re.match('linux', base_platform, re.IGNORECASE | re.DOTALL):
		full_linux_version, linux_version = findLinuxVersion()
		if full_linux_version != "":
			platforms = [full_linux_version, linux_version,
						 base_platform, 'linux', 'unix']
		elif linux_version != "":
			platforms = [linux_version, base_platform, 'linux', 'unix']
		else:		   
			platforms = [base_platform, 'linux', 'unix']
	else:
		platforms = [base_platform, 'unix']
	return platforms

# This is used by findPlatform. It figures out which distribution of
# Linux we're running on. 
def findLinuxVersion():
	try: 
		issue_file = open('/etc/issue', 'r')
		lines = issue_file.readlines()
		versions = ("", "")
		for line in lines:
			distro = None
			if re.search('Red Hat*', line):
				distro = 'redhat'
			elif re.search('Mandrake', line):
				distro = 'mandrake'
			elif re.search('SuSE', line):
				distro = 'suse'
			elif re.search('Fermi', line):
				distro = 'fermi'

			if distro != None:
				version_match = re.search(r"\d+\.\d+", line)
				if version_match:
					version_string = line[version_match.start():version_match.end()]
					versions = ('linux-' + distro + '-' + version_string,
								'linux-'+distro)
				else:
					versions = ('', 'linux-'+distro)
				break
	except IOError:
		versions = ("", "")
		
	return versions

# This class is like a simple dictionary.
# Unlike the normal dictionary, it can take a list of indices.
# It searches them in order until it finds one that matches.
# This is used to look for the best matching platform in the list
# of systems
# We don't implement all methods that a dictionary has, just because
# we don't need them right now. 
class Platforms:
	def __init__(self, dictionary):
		self.dictionary = dictionary
  	def __getitem__(self, index):
  		value = None;
  		if isinstance(index, types.ListType):
  			for i in index:
  				if self.dictionary.has_key(i):
  					value = self.dictionary[i]
  					break;
  		else:
  			value = self.dictionary[index]
  		return value;
	def has_key(self, index):
		key_exists = 0;
  		if isinstance(index, types.ListType):
  			for i in index:
  				if self.dictionary.has_key(i):
  					key_exists = 1;
  					break;
  		else:
  			key_exists = self.dictionary.has_key(index)
  		return key_exists

# This is just testing code, and it is not needed for normal
# operation
def testPlatform():
	print "You are running: ", findPlatform()
	platforms = Platforms({ 'linux-i386' : ['gpt-0.2.tar.gz', 'gpt-0.2'], \
							'linux2'     : ['gpt-0.3.tar.gz', 'gpt-0.3'], \
						   })
	print "linux2 is: ", platforms['linux2']
	print "linux-i386 is: ", platforms['linux-i386']
	print "['linux-i386', 'linux2']: ", platforms[['linux-i386', 'linux2']]
	print "['linux2', 'linux-i386']: ", platforms[['linux2', 'linux-i386']]
	print "[]: ", platforms[[]]
	print "Has linux2: ", platforms.has_key('linux2')
	print "Has linux-i386: ", platforms.has_key('linux-i386')
	print "Has ['linux-i386', 'linux2']: ", platforms.has_key(['linux-i386', 'linux2'])
	print "Has ['linux2', 'linux-i386']: ", platforms.has_key(['linux2', 'linux-i386'])
	return

#testPlatform()
